#include<bits/stdc++.h>
using namespace std;

vector<int> edges_normal[50001], edges_back[50001], ans;
bool visited_normal[101][50001], visited_back[101][50001];

void dfs_normal(int k, int j) {
    if(visited_normal[j][k]) return;
    visited_normal[j][k] = true;
    for(auto curEdge : edges_normal[k]) {
        dfs_normal(curEdge, j);
    }
}

void dfs_back(int k, int j) {
    if(visited_back[j][k]) return;
    visited_back[j][k] = true;
    for(auto curEdge : edges_back[k]) {
        dfs_back(curEdge, j);
    }
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);

    int m, n, k;
    cin>>m>>n>>k;
    for(int i = 1; i <= n; i++) {
        int u, v;
        cin>>u>>v;
        edges_normal[u].push_back(v);
        edges_back[v].push_back(u);
    }

    for(int i = 0; i < k; i++) {
        int u, v;
        cin>>u>>v;
        dfs_normal(u, i);
        dfs_back(v, i);
    }

    int ansNum = 0;
    cout<<endl;
    for(int i = 1; i <= m; i++) {
        //cout<<i<<" "<<visited1[i]<<" "<<visited2[i]<<" "<<visited3[i]<<" "<<visited4[i]<<endl;
        bool b = true;
        for(int j = 0; j < k; j++) {
            if(visited_normal[j][i] == false || visited_back[j][i] == false) {
                b = false;
                break;
            }
        }
        if(b) {
            ansNum++;
            ans.push_back(i);
        }
    }

    cout<<ansNum<<endl;
    for(int i = 0; i < ansNum; i++) {
        cout<<ans[i]<<" ";
    }
    cout<<endl;


    return 0;
}

