#include <bits/stdc++.h>
#define endl '\n'

using namespace std;

constexpr int MAXN = 100000;
vector <int> Graph[MAXN];
vector <int> Graph_Backward[MAXN];
uint8_t visits[MAXN];
bool used1[MAXN], used2[MAXN];
vector <int> answers;

void bfs(int start, bool* used, vector <int>* graph)
{
    used[start] = true;
    queue <int> q;
    q.push(start);

    while (!q.empty())
    {
        int k = q.front();
        q.pop();

        for (int i:graph[k])
        {
            if (used[i] == false)
            {
                q.push(i);
                used[i] = true;
            }
        }
    }
}

int main()
{
    ios::sync_with_stdio(false);
    cin.tie(NULL); cout.tie(NULL);

    int V, E, K;
    cin >> V >> E >> K;

    for (int i = 0; i < E; i++)
    {
        int x, y;
        cin >> x >> y;
        Graph[x].push_back(y);
        Graph_Backward[y].push_back(x);
    }

    for (int i = 0; i < K; i++)
    {
        int start, dest;
        cin >> start >> dest;

        memset(used1, false, sizeof(used1));
        memset(used2, false, sizeof(used2));

        bfs(start, used1, Graph);
        bfs(dest, used2, Graph_Backward);

        for (int j = 1; j <= V; j++)
            visits[j] += (used1[j]&&used2[j]);
    }

    for (int i = 1; i <= V; i++)
        if (visits[i] == K)
            answers.push_back(i);

    sort (answers.begin(), answers.end());

    int sz = answers.size();
    cout << sz << endl << answers[0];
    for (int i = 1; i < sz; i++)
        cout << " " << answers[i];
    cout << endl;

    return 0;
}
