#include <iostream>
#include <vector>
#include <set>

#define endl '\n'

using namespace std;

const int MAXM = 5e3 + 3;

int languages[MAXM][2];

vector<int> graph[MAXM];
int in_degree[MAXM];

vector<pair<int, int>> double_rooms;

void build_graph(int m) {
    for (int i = 0; i < m; ++i) {
        for (int j = i + 1; j < m; ++j) {
            for (int k = 0; k < 2; ++k) {
                if (languages[i][k] == languages[j][0] or languages[i][k] == languages[j][1]) {
                    graph[i].push_back(j);
                    graph[j].push_back(i);

                    ++in_degree[i];
                    ++in_degree[j];

                    break;
                }
            }
        }
    }
}

void find_result(int m) {
    multiset<pair<int, int>> people;
    for (int i = 0; i < m; ++i) {
        if (in_degree[i] != 0) {
            people.insert({in_degree[i], i});
        }
    }

    while (!people.empty()) {
        auto curr = people.begin();

        int curr_degree = curr->first;
        int currv = curr->second;

        people.erase(curr);

        if (curr_degree <= 0) {
            continue;
        }

        // cout << "searching: " << currv + 1 << " " << curr_degree << endl;

        int min_degree = m;
        int roommate = m;

        for (int nextv : graph[currv]) {
            if (in_degree[nextv] > 0 and in_degree[nextv] < min_degree) {
                min_degree = in_degree[nextv];
                roommate = nextv;
            }
        }

        // cout << "found roommate: " << roommate + 1 << " " << min_degree << endl;

        double_rooms.push_back({currv + 1, roommate + 1});

        for (int nextv : graph[roommate]) {
            if (nextv == currv or in_degree[nextv] <= 0) {
                continue;
            }

            auto it = people.find({in_degree[nextv], nextv});
            people.erase(it);

            --in_degree[nextv];
            people.insert({in_degree[nextv], nextv});
        }

        for (int nextv : graph[currv]) {
            if (nextv == roommate or in_degree[nextv] <= 0) {
                continue;
            }

            auto it = people.find({in_degree[nextv], nextv});
            people.erase(it);

            --in_degree[nextv];
            people.insert({in_degree[nextv], nextv});
        }

        auto it = people.find({in_degree[roommate], roommate});
        people.erase(it);

        in_degree[currv] = in_degree[roommate] = 0;
    }
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n, m;
    cin >> n >> m;

    for (int i = 0; i < m; ++i) {
        cin >> languages[i][0] >> languages[i][1];
    }

    build_graph(m);

    find_result(m);

    cout << (int) double_rooms.size() << endl;
    for (pair<int, int>& room : double_rooms) {
        cout << room.first << " " << room.second << endl;
    }

return 0;
}
