#include <iostream>
#include <vector>
#include <string>

#define endl '\n'

using namespace std;

const int MAXN = 1e5 + 3;
const int BASE = 31;

struct FenwickTree {
    int n;
    vector<int64_t> values;

    FenwickTree(int _n) : n(_n) {
        values.resize(n + 1, 0ll);
    }

    void add(int pos, int64_t val) {
        while (pos < n) {
            values[pos] += val;
            pos += (pos & (-pos));
        }
    }

    int64_t query(int pos) {
        int64_t res = 0;
        while (pos > 0) {
            res += values[pos];
            pos -= (pos & (-pos));
        }

        return res;
    }
};

string words[MAXN];
int64_t pow[MAXN];
int64_t hash_text[MAXN], hash_words[MAXN];
vector<int> last_letter_words[MAXN];

int64_t make_hash(string& s) {
    int64_t res = 0;
    for (int i = 0; i < (int) s.size(); ++i) {
        res = res + pow[i] * (s[i] - 'a' + 1);
    }

    return res;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    pow[0] = 1;
    for (int i = 1; i < MAXN; ++i) {
        pow[i] = pow[i - 1] * BASE;
    }

    string text;
    cin >> text;

    int n;
    cin >> n;

    for (int i = 0; i < n; ++i) {
        cin >> words[i];
        hash_words[i] = make_hash(words[i]);
        last_letter_words[words[i].back() - 'a'].push_back(i);
    }

    int m = (int) text.size();
    FenwickTree hash_text(m + 3);
    FenwickTree erased_letters(m + 3);
    FenwickTree multiplier(m + 3);

    multiplier.add(1, 1);

    for (int i = 0; i < m; ++i) {
        hash_text.add(i + 1, pow[i] * (text[i] - 'a' + 1));
    }

    bool is_erased_word;

    do {
        is_erased_word = false;
        int missed_letters = 0;

        for (int i = 0; i < m; ++i) {
            if (erased_letters.query(i + 1) > 0) {
                ++missed_letters;
                continue;
            }

            int curr_letter = text[i] - 'a';
            int max_length = i + 1 - missed_letters;

            for (int j : last_letter_words[curr_letter]) {
                int curr_length = (int) words[j].size();
                if (curr_length > max_length) {
                    continue;
                }

                int64_t new_word_hash = hash_words[j] * pow[i - curr_length + 1];
                int64_t word_from_text_hash = hash_text.query(i + 1)
                                            - hash_text.query(i - curr_length - missed_letters + 1)
                                            * multiplier.query(i - curr_length - missed_letters + 1);

                /*cout << "compare: " << i << " " << j << endl;
                cout << new_word_hash << " " << word_from_text_hash << endl;
                cout << i - curr_length - missed_letters + 1 << endl;*/

                if (new_word_hash == word_from_text_hash) {
                    is_erased_word = true;

                    erased_letters.add(i - curr_length - missed_letters + 2, 1);
                    erased_letters.add(i + 2, -1);

                    int64_t prefix = hash_text.query(i - curr_length - missed_letters + 1);
                    hash_text.add(i - curr_length - missed_letters + 2, prefix * pow[curr_length] - prefix);

                    break;
                }
            }
        }

    } while (is_erased_word);

    for (int i = 0; i < m; ++i) {
        if (erased_letters.query(i + 1) == 0) {
            cout << text[i];
        }
    }
    cout << endl;

return 0;
}
