#include <iostream>

#define endl '\n'

using namespace std;

const int MOD = 998244353;

void add_mod(int& x, int y) {
    x += y;

    if (x >= MOD) {
        x -= MOD;
    }

    if (x < 0) {
        x += MOD;
    }
}

int mul_mod(int x, int y) {
    return 1ll * x * y % MOD;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n, m, k;
    cin >> n >> m >> k;

    if (k == 1) {
        int res = 1;
        for (int i = 0; i < n; ++i) {
            res = mul_mod(res, m);
        }

        cout << res << endl;
    }

    if (k == 2) {
        int res = 1;
        for (int i = 0; i < n; ++i) {
            res = mul_mod(res, m);
        }

        int test = m;
        for (int i = 0; i < n - 1; ++i) {
            test = mul_mod(test, m - 1);
        }

        add_mod(res, -test);

        cout << res << endl;
    }

return 0;
}
