#include <iostream>

#define endl '\n'

using namespace std;

const int MOD = 998244353;

void add_mod(int& x, int y) {
    x += y;
    if (x >= MOD) {
        x -= MOD;
    }
}

int mul_mod(int x, int y) {
    return 1ll * x * y % MOD;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n, m, k;
    cin >> n >> m >> k;

    if (k == 1) {
        int res = 1;
        for (int i = 0; i < n; ++i) {
            res = mul_mod(res, m);
        }

        cout << res << endl;
    }

    if (k == 2) {
        int res = 1;
        for (int i = 0; i < n - 2; ++i) {
            res = mul_mod(res, m);
        }

        res = mul_mod(res, n - 1);
        res = mul_mod(res, m);

        res -= m;
        if (res < 0) {
            res += MOD;
        }

        cout << res << endl;
    }

return 0;
}
