#include<iostream>
#include<vector>
#include<set>
using namespace std;

int broiMesta;
int broiZaqvki;

int tochki[100010];

struct DanniZaVarha{
    int broiPrPrediNego;
    int otKadeObhv;
    int doKadeObhv;
    int lqvoDete;
    int dqsnoDete;
};

vector<DanniZaVarha> varhove;
int korenNomer = -1;

int daiNovVrah(DanniZaVarha novVrah){
    varhove.push_back(novVrah);
    return varhove.size() - 1;
}

int postroiDarvo(int otKade, int doKade){
    if(otKade == doKade){
        return daiNovVrah({0, otKade, doKade, -1, -1});
    }

    int lqvoDete = postroiDarvo(otKade, (otKade + doKade)/2);
    int dqsnoDete = postroiDarvo((otKade + doKade)/2 + 1, doKade);

    return daiNovVrah({0, otKade, doKade, lqvoDete, dqsnoDete});
}

void update(int segashenVrah, int otKade, int doKade, int sKolko){
    if(segashenVrah == -1 || varhove[segashenVrah].otKadeObhv > doKade || varhove[segashenVrah].doKadeObhv < otKade){
        return ;
    }
    if(otKade <= varhove[segashenVrah].otKadeObhv && doKade >= varhove[segashenVrah].doKadeObhv){
        varhove[segashenVrah].broiPrPrediNego += sKolko;
        return ;
    }

    update(varhove[segashenVrah].lqvoDete, otKade, doKade, sKolko);
    update(varhove[segashenVrah].dqsnoDete, otKade, doKade, sKolko);
}

int query(int segashenVrah, int kade){
    if(segashenVrah == -1 || varhove[segashenVrah].doKadeObhv < kade || varhove[segashenVrah].otKadeObhv > kade){
        return 0;
    }
    if(varhove[segashenVrah].otKadeObhv == kade && varhove[segashenVrah].doKadeObhv == kade){
        return varhove[segashenVrah].broiPrPrediNego;
    }

    return varhove[segashenVrah].broiPrPrediNego +
            query(varhove[segashenVrah].lqvoDete, kade) +
            query(varhove[segashenVrah].dqsnoDete, kade);
}

vector<int> otgovori;

int main(){

    cin>>broiMesta>>broiZaqvki;

    korenNomer = postroiDarvo(0, broiMesta - 1);

    for(int i = 0; i < broiZaqvki; i++){
        int tip;

        cin>>tip;

        if(tip == 1){
            int sledKoe;

            cin>>sledKoe;
            sledKoe--;


            update(korenNomer, sledKoe + 1, broiMesta - 1, 1);
        }else{
            if(tip == 2){
                int sledKoe;

                cin>>sledKoe;
                sledKoe--;

                update(korenNomer, sledKoe + 1, broiMesta - 1, -1);
            }else{
                if(tip == 3){
                    int koeMqsto;
                    int kolkoTochki;

                    cin>>koeMqsto>>kolkoTochki;
                    koeMqsto--;

                    tochki[koeMqsto] += kolkoTochki;
                }else{
                    int otKade;
                    int doKade;
                    cin>>otKade>>doKade;

                    otKade--;
                    doKade--;


                    int tukaOtg = 0;

                    int tukaQuery = query(korenNomer, otKade);

                    if(tukaQuery%2 == 1){
                        tukaOtg = tochki[otKade];
                    }

                    otgovori.push_back(tukaOtg);

                    //cout<<tukaOtg<<endl;

                }
            }
        }
    }

    for(int i = 0; i < (int)otgovori.size(); i++){
        cout<<otgovori[i]<<endl;
    }

    return 0;
}
