#include<iostream>
#include<vector>
#include<set>
using namespace std;

int broiMesta;
int broiZaqvki;

set<int> pregradi;

struct DanniZaVarha{
    int maxVPoddarvo;
    int otKadeObhv;
    int doKadeObhv;
    int lqvoDete;
    int dqsnoDete;
};

vector<DanniZaVarha> varhove;
int korenNomer = -1;

int kakavEMaxaTam(int kade){
    if(kade == -1){
        return 0;
    }
    return varhove[kade].maxVPoddarvo;
}

int daiNovVrah(DanniZaVarha novVrah){
    varhove.push_back(novVrah);
    return varhove.size() - 1;
}

int postroiDarvo(int otKade, int doKade){
    if(otKade == doKade){
        return daiNovVrah({0, otKade, doKade, -1, -1});
    }

    int lqvoDete = postroiDarvo(otKade, (otKade + doKade)/2);
    int dqsnoDete = postroiDarvo((otKade + doKade)/2 + 1, doKade);

    return daiNovVrah({0, otKade, doKade, lqvoDete, dqsnoDete});
}

void update(int segashenVrah, int kade, int sKolko){
    if(segashenVrah == -1 || varhove[segashenVrah].doKadeObhv < kade || varhove[segashenVrah].otKadeObhv > kade){
        return ;
    }
    if(varhove[segashenVrah].otKadeObhv == kade && varhove[segashenVrah].doKadeObhv == kade){
        varhove[segashenVrah].maxVPoddarvo += sKolko;
        return ;
    }

    update(varhove[segashenVrah].lqvoDete, kade, sKolko);
    update(varhove[segashenVrah].dqsnoDete, kade, sKolko);

    varhove[segashenVrah].maxVPoddarvo =
        max(kakavEMaxaTam(varhove[segashenVrah].lqvoDete), kakavEMaxaTam(varhove[segashenVrah].dqsnoDete));
}

int query(int segashenVrah, int otKade, int doKade){
    if(segashenVrah == -1 || varhove[segashenVrah].otKadeObhv > doKade || varhove[segashenVrah].doKadeObhv < otKade){
        return 0;
    }
    if(otKade <= varhove[segashenVrah].otKadeObhv && doKade >= varhove[segashenVrah].doKadeObhv){
        return varhove[segashenVrah].maxVPoddarvo;
    }

    return max(query(varhove[segashenVrah].lqvoDete, otKade, doKade), query(varhove[segashenVrah].dqsnoDete, otKade, doKade));
}

vector<int> otgovori;

int main(){

    cin>>broiMesta>>broiZaqvki;

    korenNomer = postroiDarvo(0, broiMesta - 1);

    for(int i = 0; i < broiZaqvki; i++){
        int tip;

        cin>>tip;

        if(tip == 1){
            int sledKoe;

            cin>>sledKoe;
            sledKoe--;

            pregradi.insert(sledKoe);
        }else{
            if(tip == 2){
                int sledKoe;

                cin>>sledKoe;
                sledKoe--;

                pregradi.erase(sledKoe);
            }else{
                if(tip == 3){
                    int koeMqsto;
                    int kolkoTochki;

                    cin>>koeMqsto>>kolkoTochki;
                    koeMqsto--;

                    update(korenNomer, koeMqsto, kolkoTochki);
                }else{
                    int otKade;
                    int doKade;
                    cin>>otKade>>doKade;

                    otKade--;
                    doKade--;


                    int tukaOtg = 0;

                    if(pregradi.size() == 0){
                        tukaOtg = 0;
                    }else{
                        if(pregradi.size() == 1){
                            int nachalo = *pregradi.begin() + 1;
                            int krai = doKade;

                            tukaOtg = query(korenNomer, nachalo, krai);
                        }else{
                            set<int>::iterator lqvo = pregradi.begin();
                            set<int>::iterator dqsno = lqvo;
                            dqsno++;

                            int broqch = 1;

                            while(*dqsno < otKade){
                                lqvo++;
                                dqsno++;
                                broqch++;
                            }

                            int suma = 0;

                            while(lqvo != pregradi.end()){
                                //cout<<"broqcha e "<<broqch<<endl;
                                if(broqch%2 ==0 ){
                                    //cout<<"propuskame"<<endl;
                                }else{
                                    int lqvata = *lqvo + 1;

                                    lqvata = max(lqvata, otKade);

                                    int dqsnata = broiMesta - 1;

                                    if(dqsno != pregradi.end()){
                                        dqsnata = *dqsno;
                                    }

                                    dqsnata = min(dqsnata, doKade);

                                    //cout<<"lqvata e "<<lqvata<<" dqsnata e "<<dqsnata<<endl;

                                    if(lqvata >= otKade && lqvata <= doKade){
                                        int tuka = query(korenNomer, lqvata, dqsnata);
                                        //cout<<"queryto kazva "<<tuka<<endl;
                                        suma += tuka;
                                    }else{
                                        if(lqvata > doKade){
                                            break;
                                        }
                                    }
                                }
                                broqch++;
                                lqvo++;
                                dqsno++;
                            }

                            tukaOtg = suma;
                        }
                    }

                    otgovori.push_back(tukaOtg);

                    //cout<<tukaOtg<<endl;

                }
            }
        }
    }

    for(int i = 0; i < (int)otgovori.size(); i++){
        cout<<otgovori[i]<<endl;
    }

    return 0;
}
