// От софия до банско да гърми шампанско

#include <iostream>
#include <cmath>
#include <cassert>
#include <algorithm>
#include <vector>
#include <set>
typedef long long llong;
const int maxn = 100000 + 10;

struct Node
{
    Node *left, *right;
    int value, subtreeOR, subtreeAND;
    int subtreeSize, y;

    Node()
    {
        left = right = nullptr;
    }

    Node(int val, int _y)
    {
        left = right = nullptr;
        y = _y;
        value = val;
        subtreeAND = subtreeOR = value;
        subtreeSize = 1;
    }
};

Node *treap;
int n, q;
int a[maxn];

void recover(Node *curr)
{
    if (curr == nullptr) return;
    curr->subtreeOR = curr->subtreeAND = curr->value;
    curr->subtreeSize = 1;

    if (curr->left != nullptr)
    {
        curr->subtreeSize += curr->left->subtreeSize;
        curr->subtreeOR |= curr->left->subtreeOR;
        curr->subtreeAND &= curr->left->subtreeAND;
    }

    if (curr->right != nullptr)
    {
        curr->subtreeSize += curr->right->subtreeSize;
        curr->subtreeOR |= curr->right->subtreeOR;
        curr->subtreeAND &= curr->right->subtreeAND;
    }
};

void split(Node *curr, Node *&left, Node *&right, int k)
{
    if (curr == nullptr)
    {
        left = right = nullptr;
        return;
    }

    if (curr->value <= k)
    {
        left = curr;
        split(curr->right, left->right, right, k);
        recover(left);
    } else 
    {
        right = curr;
        split(curr->left, left, right->left, k);
        recover(right);
    }
}

void split2(Node *curr, Node *&left, Node *&right, int k)
{
    if (curr == nullptr)
    {
        left = right = nullptr;
        return;
    }

    int size = 1;
    if (curr->left != nullptr) size += curr->left->subtreeSize;

    if (size <= k)
    {
        left = curr;
        split2(curr->right, left->right, right, k-size);
        recover(left);
    } else 
    {
        right = curr;
        split2(curr->left, left, right->left, k);
        recover(right);
    }
}

void merge(Node *&curr, Node *left, Node *right)
{
    if (right == nullptr)
    {
        curr = left;
        return;
    }

    if (left == nullptr)
    {
        curr = right;
        return;
    }

    if (left->y > right->y)
    {
        curr = left;
        merge(curr->right, left->right, right);
    } else 
    {
        curr = right;
        merge(curr->left, left, right->left);
    }

    recover(curr);
}

void insert(int value)
{
    // std::cout << "insert: " << value << '\n';
    Node *left, *right, *mid, *rright, *m, *m1, *newNode = new Node(value, rand());
    split(treap, left, right, value-1);
    // std::cout << "done splitting: " << (mid == nullptr) << '\n';
    
    merge(m, newNode, right);
    merge(treap, left, m);
    // std::cout << "merging\n";
    // std::cout << "first\n";
    
    // std::cout << "second\n";
}

void erase(int value)
{
    Node *left, *right, *mid, *rright, *m, *m1, *removed;
    split(treap, left, right, value-1);
    split(right, mid, rright, value);
    
    assert(mid != nullptr);

    split2(mid, removed, m, 1);
    merge(m1, m, rright);
    merge(treap, left, m1);
}

int search(Node *curr, int bit)
{
    // std::cout << "search: " << (curr == nullptr) << ' ' << (curr == nullptr ? 0 : curr->subtreeSize) << ' ' << bit << '\n';
    if (curr == nullptr)
    {
        // std::cout << "return\n";
        return 1;
    }

    int leftOR = curr->value;
    int size = 1;
    if (curr->left != nullptr) size += curr->left->subtreeSize, leftOR |= curr->left->subtreeOR;
    // std::cout << "here: " << leftOR << ' ' << size << '\n';
    if (leftOR & (1 << bit)) return search(curr->left, bit);
    return size + search(curr->right, bit); 
}

int bitCnt[31];
std::multiset < int > s;
void add(int x)
{
    // std::cout << "add: " << x << '\n' << std::flush;
    for (int i = 0 ; i < 30 ; ++i)
        if (x & (1 << i)) ++bitCnt[i];
    insert(x);
    s.insert(x);
}

void remove(int x)
{
    // std::cout << "remove: " << x << '\n' << std::flush;
    for (int i = 0 ; i < 30 ; ++i)
        if (x & (1 << i)) --bitCnt[i];
    // std::cout << "treap erase\n";
    erase(x);
    // std::cout << "set erase\n";
    s.erase(s.find(x));
    // std::cout << "done\n";
}

bool answer()
{
    int maximal = *s.rbegin();
    int leftmost = maxn;

    // std::cout << "answer: " << maximal << '\n';
    for (int i = 0 ; i < 30 ; ++i)
    {
        if (bitCnt[i] == 0 || (bitCnt[i] >= 2 && (maximal & (1 << i)) != 0)) continue;
        // std::cout << "search: " << i << '\n';
        int res = search(treap, i);
        if (maximal & (1 << i)) --res;
        leftmost = std::min(leftmost, res);
        // std::cout << "leftmost: " << leftmost << '\n';
    }

    if (leftmost == maxn) return 1;
    if (leftmost <= 1) return 0;

    Node *left, *right;
    split2(treap, left, right, leftmost-1);
    bool ans = 0;

    // std::cout << "here: " << left->subtreeOR << ' ' << right->subtreeAND << ' ' << left->subtreeSize << ' ' << right->subtreeSize << '\n';
    if (left->subtreeOR == right->subtreeAND) ans = 1;
    merge(treap, left, right);
    return ans;

}

int bucketSize;
struct Query
{
    int l, r, ix;
    inline friend bool operator < (Query a, Query b)
    {
        if (a.l / bucketSize != b.l / bucketSize) return a.l < b.l;
        return a.r < b.r;
    }
} query[maxn];

bool output[maxn];
void solve()
{
    bucketSize = sqrt(n);
    treap = nullptr;

    for (int i = 1 ; i <= q ; ++i)
    {
        std::cin >> query[i].l >> query[i].r;
        query[i].ix = i;
    }

    // std::sort(query+1, query+1+q);
    int l = 1, r = 1;
    add(a[1]);
    for (int i = 1 ; i <= q ; ++i)
    {
        // std::cout << "l, r: " << l << ' ' << r << '\n';
        int ql = query[i].l;
        int qr = query[i].r;
    
        while (l > ql) add(a[--l]); 
        while (r < qr) add(a[++r]); 
        while (l < ql) remove(a[l++]); 
        while (r > qr) remove(a[r--]);
        // std::cout << "reached query: \n";

        output[query[i].ix] = answer(); 
    }

    for (int i = 1 ; i <= q ; ++i)
    {
        if (output[i]) std::cout << "Yes\n";
        else std::cout << "No\n";
    }
}

void read()
{
    std::cin >> n >> q;
    for (int i = 1 ; i <= n ; ++i) std::cin >> a[i];
}

void fastIO()
{
    std::ios_base :: sync_with_stdio(0);
    std::cin.tie(nullptr);
    std::cout.tie(nullptr);
}

int main() 
{
    // fastIO();
    read();
    solve();

    return 0;
}

/*
6 1
13 15 13 5 1 7
1 5
2 5
3 6
4 6
*/