// От софия до банско да гърми шампанско

#include <iostream>
#include <iomanip>
#include <cmath>
typedef long long llong;
const int maxn = 100000 + 10;

int fenwick[maxn], n, q;
llong a[maxn];
bool divider[maxn];

void fenwickUpdate(int x, int val)
{
    for (int i = x ; i < maxn ; i += i & (-i))
        fenwick[i] += val;
}

int fenwickQuery(int x)
{
    int ans = 0;
    for (int i = x ; i > 0 ; i -= i & (-i))
        ans += fenwick[i];
    return ans;
}


void solve()
{
    int qType, x, y;
    std::cin >> n >> q;
    for (int i = 1 ; i <= q ; ++i)
    {
        std::cin >> qType >> x;
        if (qType == 1)
        {
            divider[x] = 1;
            fenwickUpdate(x, 1);
        }

        if (qType == 2)
        {
            divider[x] = 0;
            fenwickUpdate(x, -1);
        }

        if (qType == 3)
        {
            std::cin >> y;
            a[x] += y;
        }

        if (qType == 4)
        {
            std::cin >> y;
            llong currmax = 0;
            llong currzone = fenwickQuery(x-1) & 1;
            llong ans = 0;
            for (int i = x ; i <= y ; ++i)
            {
                currmax = std::max(currmax, a[i]);
                if (i == y || divider[i])
                {
                    if (currzone) ans += currmax;
                    currmax = 0;
                    currzone = !currzone;
                }
            }

            std::cout << ans << '\n';
        }
    }
}

void fastIO()
{
    std::ios_base :: sync_with_stdio(0);
    std::cin.tie(nullptr);
    std::cout.tie(nullptr);
}

int main() 
{
    fastIO();
    solve();

    return 0;
}