// От софия до банско да гърми шампанско

#include <iostream>
#include <iomanip>
#include <cmath>
typedef long long llong;
const int maxn = 100000 + 10;

struct Node
{
    int cntZones;
    llong oddSum;
    llong evenSum;
    llong maxPrefix;
    llong maxSuffix;

    Node()
    {
        cntZones = 0;
        oddSum = evenSum = 0;
        maxPrefix = maxSuffix = 0;
    }

} tree[4*maxn];

int fenwick[maxn], n, q;
llong a[maxn];
bool divider[maxn];

void fenwickUpdate(int x, int val)
{
    for (int i = x ; i < maxn ; i += i & (-i))
        fenwick[i] += val;
}

int fenwickQuery(int x)
{
    int ans = 0;
    for (int i = x ; i > 0 ; i -= i & (-i))
        ans += fenwick[i];
    return ans;
}

Node combine(Node left, Node right, int l, int r)
{
    if (left.cntZones == -1) return right;
    if (right.cntZones == -1) return left;
    Node res;
    int mid = (l+r)/2;
    if (divider[mid])
    {
        res.cntZones = left.cntZones + right.cntZones;
        if (left.cntZones & 1)
        {
            res.oddSum = left.oddSum + right.evenSum;
            res.evenSum = left.evenSum + right.oddSum;
        } else
        {
            res.oddSum = left.oddSum + right.oddSum;
            res.evenSum = left.evenSum + right.evenSum;
        }

        res.maxPrefix = left.maxPrefix;
        res.maxSuffix = right.maxSuffix;
    } else 
    {
        res.cntZones = left.cntZones + right.cntZones;
        if (left.cntZones & 1)
        {
            res.oddSum = left.oddSum + right.evenSum - left.maxSuffix - right.maxPrefix + std::max(left.maxSuffix, right.maxPrefix);
            res.evenSum = left.evenSum + right.oddSum;
        } else
        {
            res.oddSum = left.oddSum + right.oddSum;
            res.evenSum = left.evenSum + right.evenSum - left.maxSuffix - right.maxPrefix + std::max(left.maxSuffix, right.maxPrefix);
        }

        res.maxPrefix = left.maxPrefix;
        res.maxSuffix = right.maxSuffix;
    }

    return res;
}

void update(int l, int r, int node, int queryIx, int queryVal)
{
    if (l == r)
    {
        tree[node].cntZones = divider[l];
        a[l] += queryVal;
        if (tree[node].cntZones == 0) tree[node].maxSuffix = a[l];
        else tree[node].maxSuffix = 0;
        tree[node].maxPrefix = a[l];
        tree[node].evenSum = a[l];
        tree[node].oddSum = 0;
        
        return;
    }

    int mid = (l+r)/2;
    if (queryIx <= mid) update(l, mid, 2*node, queryIx, queryVal);
    else update(mid+1, r, 2*node+1, queryIx, queryVal);

    tree[node] = combine(tree[2*node], tree[2*node+1], l, r);
}

Node query(int l, int r, int node, int queryL, int queryR)
{
    if (queryL <= l && r <= queryR) return tree[node];

    int mid = (l+r)/2;
    Node res; res.cntZones = -1;
    if (queryL <= mid) res = combine(res, query(l, mid, 2*node, queryL, queryR), l, r);
    if (mid+1 <= queryR) res = combine(res, query(mid+1, r, 2*node+1, queryL, queryR), l, r);

    // std::cout << "query: " << l << ' ' << r << " = " << res.cntZones << ' ' << res.evenSum << ' ' << res.oddSum << ' ' << res.maxPrefix << ' ' << res.maxSuffix << '\n';
    return res;
}

void solve()
{
    int qType, x, y;
    std::cin >> n >> q;
    for (int i = 1 ; i <= q ; ++i)
    {
        std::cin >> qType >> x;
        if (qType == 1)
        {
            divider[x] = 1;
            fenwickUpdate(x, 1);
            update(1, n, 1, x, 0);
        }

        if (qType == 2)
        {
            divider[x] = 0;
            fenwickUpdate(x, -1);
            update(1, n, 1, x, 0);
        }

        if (qType == 3)
        {
            std::cin >> y;
            update(1, n, 1, x, y);
        }

        if (qType == 4)
        {
            std::cin >> y;
            Node res = query(1, n, 1, x, y);
            int dividers = fenwickQuery(x-1);
            if (dividers & 1) std::cout << res.evenSum << '\n';
            else std::cout << res.oddSum << '\n';
        }
    }
}

void fastIO()
{
    std::ios_base :: sync_with_stdio(0);
    std::cin.tie(nullptr);
    std::cout.tie(nullptr);
}

int main() 
{
    fastIO();
    solve();

    return 0;
}