#include <iostream>
#include <iomanip>
#include <cmath>
typedef long long llong;
const int maxn = 300000 + 10;

int a[maxn], n, k;
llong prefix[maxn];

void solve()
{
    for (int i = 1 ; i <= n ; ++i) prefix[i] = prefix[i-1] + a[i];
    double ans = 0;
    for (int i = k ; i < std::min(n+1, k + (int)sqrt(n)) ; ++i)
    {
        llong curr = 0;
        for (int j = i ; j <= n ; ++j)
        {
            ans = std::max(ans, (prefix[j] - prefix[j-i]) / double(i));
        }
    }

    std::cout << std::fixed << std::setprecision(5) << ans << '\n';
}

void read()
{
    std::cin >> n >> k;
    for (int i = 1 ; i <= n ; ++i) std::cin >> a[i];
}

void fastIO()
{
    std::ios_base :: sync_with_stdio(0);
    std::cin.tie(nullptr);
    std::cout.tie(nullptr);
}

int main() 
{
    fastIO();
    read();
    solve();

    return 0;
}