#include <iostream>
#include <iomanip>
typedef long long llong;
const int maxn = 100000 + 10;

int a[maxn], n, k;
llong sums[maxn];

void solve()
{
    for (int i = 1 ; i <= n ; ++i)
    {
        llong curr = 0;
        for (int j = i ; j <= n ; ++j)
        {
            curr += a[j];
            sums[j-i+1] = std::max(sums[j-i+1], curr);
        }
    }

    double ans = 0.0;
    for (int i = k ; i <= n ; ++i) 
    {
        ans = std::max(ans, sums[i] / double(i));
    }

    std::cout << std::fixed << std::setprecision(5) << ans << '\n';
}

void read()
{
    std::cin >> n >> k;
    for (int i = 1 ; i <= n ; ++i) std::cin >> a[i];
}

void fastIO()
{
    std::ios_base :: sync_with_stdio(0);
    std::cin.tie(nullptr);
    std::cout.tie(nullptr);
}

int main() 
{
    fastIO();
    read();
    solve();

    return 0;
}