#include<bits/stdc++.h>
#define MAXN 400007
using namespace std;

long long type,a,b,c,d,res;

struct node{
    long long val,y,sz;
    long long maxl,maxr;
    node *l,*r;

    node (long long val,long long y){
        this->val=val;
        this->y=y;
        this->sz=1;
        this->maxl=this->maxr=0;
        this->l=this->r=NULL;
    }
};

node *treap;

void recover(node* &curr){
    if(curr==NULL)return;

    curr->sz=1;
    curr->maxl=curr->maxr=0;
    if(curr->l!=NULL){
        curr->sz+=curr->l->sz;
        curr->maxl=curr->l->maxl;
        curr->maxr=curr->l->maxr;
    }

    if((curr->sz)%2==0){
        curr->maxr+=curr->val;
    }else{
        curr->maxl+=curr->val;
    }

    if(curr->r!=NULL){
        if((curr->sz)%2==0){
            curr->maxl+=curr->r->maxl;
            curr->maxr+=curr->r->maxr;
        }else{
            curr->maxl+=curr->r->maxr;
            curr->maxr+=curr->r->maxl;
        }
        curr->sz+=curr->r->sz;
    }
}

void split(node *curr,node* &l,node* &r,int x){
    if(curr==NULL){
        l=NULL; r=NULL;
        return;
    }

    int poss=1;
    if(curr->l!=NULL)poss+=curr->l->sz;

    if(poss<=x){
        l=curr;
        split(curr->r,l->r,r,x-poss);
        recover(l);
    }else{
        r=curr;
        split(curr->l,l,r->l,x);
        recover(r);
    }
}

void mergev(node* &curr,node *l,node *r){
    if(l==NULL){
        curr=r;
        return;
    }
    if(r==NULL){
        curr=l;
        return;
    }

    if(l->y>r->y){
        curr=l;
        mergev(curr->r,l->r,r);
    }else{
        curr=r;
        mergev(curr->l,l,r->l);
    }
    recover(curr);
}

void insertv(int poss,long long val){
    node *l,*r;
    split(treap,l,r,poss-1);
    node *tt=new node(val,rand()%100000);
    mergev(treap,l,tt);
    mergev(treap,treap,r);
}

void erasev(int poss){
    node *l,*r,*ll,*rr;
    split(treap,l,r,poss);
    split(l,ll,rr,poss-1);
    mergev(treap,ll,r);
}

long long maxv(int from,int to,int d){
    if(from>to)return 0;
    long long res=0;

    node *l,*r,*ll,*rr;
    split(treap,l,r,to);
    split(l,ll,rr,from-1);

    if(rr!=NULL and d==0)res=rr->maxr;
    else if(rr!=NULL and d==1)res=rr->maxl;

    mergev(treap,ll,rr);
    mergev(treap,treap,r);

    return res;
}

int n,q;

int pos[4*MAXN];
long long maxs[4*MAXN];

void update(int v,int l,int r,int ll,int rr,int val){
    if(ll>rr)return;
    if(l==ll and r==rr){
        pos[v]+=val;
    }else{
        int tt=(l+r)/2;
        update(2*v,l,tt,ll,min(tt,rr),val);
        update(2*v+1,tt+1,r,max(tt+1,ll),rr,val);
    }
}

int getpos(int v,int l,int r,int p){
    if(l==r)return pos[v];
    int tt=(l+r)/2;
    if(p<=tt)return pos[v]+getpos(2*v,l,tt,p);
    else return pos[v]+getpos(2*v+1,tt+1,r,p);
}

int ltree[4*MAXN],rtree[4*MAXN];

void pshl(int v){
    if(ltree[v]==0)return;
    ltree[2*v]=ltree[2*v+1]=ltree[v];
    ltree[v]=0;
}

int leftb(int v,int l,int r,int p){
    if(l==r)return ltree[v];
    else{
        pshl(v);
        int tt=(l+r)/2;
        if(p<=tt)return leftb(2*v,l,tt,p);
        else return leftb(2*v+1,tt+1,r,p);
    }
}

void upleft(int v,int l,int r,int ll,int rr,int val){
    if(ll>rr)return;
    if(l==ll and r==rr){
        ltree[v]=val;
    }else{
        pshl(v);
        int tt=(l+r)/2;
        upleft(2*v,l,tt,ll,min(tt,rr),val);
        upleft(2*v+1,tt+1,r,max(tt+1,ll),rr,val);
    }
}

void pshr(int v){
    if(rtree[v]==0)return;
    rtree[2*v]=rtree[2*v+1]=rtree[v];
    rtree[v]=0;
}

int rightb(int v,int l,int r,int p){
    if(l==r)return rtree[v];
    else{
        pshr(v);
        int tt=(l+r)/2;
        if(p<=tt)return rightb(2*v,l,tt,p);
        else return rightb(2*v+1,tt+1,r,p);
    }
}

void upright(int v,int l,int r,int ll,int rr,int val){
    if(ll>rr)return;
    if(l==ll and r==rr){
        rtree[v]=val;
    }else{
        pshr(v);
        int tt=(l+r)/2;
        upright(2*v,l,tt,ll,min(tt,rr),val);
        upright(2*v+1,tt+1,r,max(tt+1,ll),rr,val);
    }
}

void upgrade(int v,int l,int r,int p,long long val){
    if(l==r){
        maxs[v]+=val;
    }else{
        int tt=(l+r)/2;
        if(p<=tt)upgrade(2*v,l,tt,p,val);
        else upgrade(2*v+1,tt+1,r,p,val);
        maxs[v]=max(maxs[2*v],maxs[2*v+1]);
    }
}

long long getmax(int v,int l,int r,int ll,int rr){
    if(ll>rr)return 0;
    if(l==ll and r==rr){
        return maxs[v];
    }else{
        int tt=(l+r)/2;
        return max( getmax(2*v,l,tt,ll,min(tt,rr)) , getmax(2*v+1,tt+1,r,max(tt+1,ll),rr) );
    }
}

int main(){

    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);

    cin>>n>>q;

    insertv(0,1);
    pos[1]=1;

    upleft(1,1,n,1,n,1);
    upright(1,1,n,1,n,n);

    for(int i=1;i<=q;i++){
        cin>>type;
        if(type==1){
            cin>>a;
            update(1,1,n,a+1,n,1);

            c=getpos(1,1,n,a);
         //   erasev(c);
         //   insertv(c,getmax(1,1,n,leftb(1,1,n,a),a));
        //    insertv(c+1,getmax(1,1,n,a+1,rightb(1,1,n,a+1)));

            upright(1,1,n,leftb(1,1,n,a),a,a);
            upleft(1,1,n,a+1,rightb(1,1,n,a+1),a+1);
        }else if(type==2){
            cin>>a;
            update(1,1,n,a+1,n,-1);

            c=getpos(1,1,n,a);
         //   erasev(c); erasev(c);
         //   insertv(c,getmax(1,1,n,leftb(1,1,n,a),rightb(1,1,n,a+1)));

            c=leftb(1,1,n,a); d=rightb(1,1,n,a+1);
            upleft(1,1,n,c,d,c);
            upright(1,1,n,c,d,d);
        }else if(type==3){
            cin>>a>>b;
            upgrade(1,1,n,a,b);
            c=getpos(1,1,n,a);
        //    erasev(c);
        //    insertv(c,getmax(1,1,n,leftb(1,1,n,a),rightb(1,1,n,a)));
        }else{
            cin>>a>>b;
            c=getpos(1,1,n,a);
            d=getpos(1,1,n,b);

            res=0;
            if(c%2==0){
                res=getmax(1,1,n,a,rightb(1,1,n,a));
           //     res+=maxv(c+1,d-1,0);
                if(d%2==0){
                    res+=getmax(1,1,n,leftb(1,1,n,b),b);
                }
            }else{
             //   res=maxv(c+1,d-1,1);
                if(d%2==0){
                    res+=getmax(1,1,n,leftb(1,1,n,b),b);
                }
            }
            cout<<res<<"\n";
        }
    }


    return 0;
}

