#include <iostream>
#include <algorithm>

bool can_divide(int* arr, int l, int r, int c)
{
    if (c > r) return false;

    int first = arr[l];
    for (int i = l + 1; i < c; ++i)
    {
        first = first & arr[i];
    }

    int second = arr[c];
    for (int i = c; i <= r; ++i)
    {
        second = second | arr[i];
    }

    return (first == second) || can_divide(arr, l, r, c + 1);
}

int main()
{
    int n, q;
    std::cin >> n >> q;

    std::vector<int> arr(n);
    bool *results = new bool[q];

    for (int i = 0; i < n; ++i)
        std::cin >> arr[i];

    for (int i = 0; i < q; ++i)
    {
        int l, r;
        std::cin >> l >> r;
        l -= 1;
        r -= 1;

        results[i] = can_divide(arr, l, r, l + 1);
    }

    for (int i = 0; i < q; ++i)
        std::cout << results[i] << "\n";
}
