#include <iostream>
#include <string>
#include <cstring>
#include <memory>
#include <vector>

enum
{
    AddDivider = 1,
    RemoveDivider = 2,
    AddToScore = 3,
    Result = 4
};

int main()
{
    int n, q;
    std::cin >> n >> q;

    std::vector<int> scores(n);
    std::vector<int> dividers(n);
    std::vector<int> result;

    for (int i = 0; i < q; ++i)
    {
        int cmd, arg1, arg2;
        std::cin>>cmd>>arg1;
        if (cmd == AddDivider)
        {
            dividers[arg1 - 1] = 1;
        }
        else if (cmd == RemoveDivider)
        {
            dividers[arg1 - 1] = 0;
        }
        else if (cmd == AddToScore)
        {
            std::cin>>arg2;
            scores[arg1 - 1] += arg2;
        }
        else if (cmd == Result)
        {
            std::cin>>arg2;

            int room = 0;
            int last = 0;
            for (int i = 0; i < arg1; ++i)
            {
                if (i + 1 == arg1) break;
                if (dividers[i])
                {
                    last = i;
                    ++room;
                }
            }

            int sum = 0;
            for (int i = arg1 - 1; i < arg2; ++i)
            {
                if (room % 2 != 0 && (i - last) % 2 != 0)
                {
                    sum += scores[i];
                }
                if (dividers[i])
                {
                    last = i;
                    ++room;
                }
            }

            result.push_back(sum);
        }
    }

    for (int i =0; i < result.size(); ++i)
        std::cout << result[i] << "\n";
}
