#include <iostream>
#include <vector>
#include <map>
#include <cstring>

double solve(int *arr, int n, int k, int c,
             std::map<std::pair<int, int>,double>& memo)
{
    if (c + k > n) return 0.0;

    double sum = 0.0;
    if (memo.find({c, k - 1}) != memo.end())
    {
        sum = memo[{c, k - 1}];
        sum += arr[c + k - 1];
        //std::cout << "using " << c << " " <<k << " " << sum <<std::endl;
    }
    else
    {
        for (int i = c; i < c + k; ++i)
        {
            sum += arr[i];
        }
        memo[{c, k}] = sum;
        //std::cout << "setting " << c << " " <<k << " " << sum <<std::endl;
    }

    double avg = sum / k;

    double next = solve(arr, n, k, c + 1, memo);
    return avg > next ? avg : next;
}

int main()
{
    int n, k;
    std::cin>>n>>k;

    int *arr = new int[n];
    for (int i = 0; i < n; ++i)
        std::cin>>arr[i];

    double max = 0.0;
    std::map<std::pair<int, int>, double> memo;
    for (int i = k; i < n; ++i)
    {
        double avg = solve(arr, n, k, 0, memo);
        if (avg > max)
            max = avg;
        ++k;
    }

    std::cout << max << std::endl;
}
