#include <iostream>
#define endl '\n'
using namespace std;

const int MAXN = 100000;

int d[MAXN + 5];
long long points[MAXN + 5], mx[MAXN + 5];
int st[MAXN + 5], en[MAXN + 5], pos[MAXN + 5];
long long tree1[4 * MAXN + 5], tree2[4 * MAXN + 5];

void build1(int v, int l, int r)
{
    if (l == r)
    {
        tree1[v] = (l % 2 == 1 ? mx[l] : 0);
        return;
    }

    int mid = (l + r) / 2;
    build1(2 * v, l, mid);
    build1(2 * v + 1, mid + 1, r);
    tree1[v] = tree1[2 * v] + tree1[2 * v + 1];
}

long long query1(int v, int l, int r, int L, int R)
{
    if (r < L or R < l) return 0;
    if (L <= l and r <= R) return tree1[v];

    int mid = (l + r) / 2;
    return query1(2 * v, l, mid, L, R) + query1(2 * v + 1, mid + 1, r, L, R);
}

void build2(int v, int l, int r)
{
    if (l == r)
    {
        tree2[v] = points[l];
        return;
    }

    int mid = (l + r) / 2;
    build2(2 * v, l, mid);
    build2(2 * v + 1, mid + 1, r);
    tree2[v] = max(tree2[2 * v], tree2[2 * v + 1]);
}

long long query2(int v, int l, int r, int L, int R)
{
    if (r < L or R < l) return 0;
    if (L <= l and r <= R) return tree2[v];

    int mid = (l + r) / 2;
    return max(query2(2 * v, l, mid, L, R), query2(2 * v + 1, mid + 1, r, L, R));
}

int main()
{
    ios :: sync_with_stdio(false);
    cin.tie(NULL); cout.tie(NULL);

    int n, q;
    cin >> n >> q;

    int cnt = 0;
    bool flag = false;
    while (q--)
    {
        int type;
        cin >> type;

        if (type == 1 or type == 2)
        {
            int p;
            cin >> p;
            d[p] ^= 1;
        }
        else if (type == 3)
        {
            int c, a;
            cin >> c >> a;
            points[c] += a;
        }
        else
        {
            if (!flag)
            {
                st[0] = 1;
                for (int i = 1; i <= n; ++ i)
                {
                    pos[i] = cnt;
                    mx[cnt] = max(mx[cnt], points[i]);
                    if (d[i])
                    {
                        en[cnt] = i;
                        cnt++;
                        st[cnt] = i + 1;
                    }
                }
                en[cnt] = n;

                build1(1, 1, cnt);
                build2(1, 1, n);

                flag = true;
            }

            int l, r;
            cin >> l >> r;

            long long ans = 0;
            int pl = pos[l], pr = pos[r];

            if (pl == pr) ans += (pl % 2 == 1 ? query2(1, 1, n, l, r) : 0);
            else
            {
                ans += (pl % 2 == 1 ? query2(1, 1, n, l, en[pl]) : 0);
                ans += (pr % 2 == 1 ? query2(1, 1, n, st[pr], r) : 0);
            }

            pl++;
            pr--;
            if (pl <= pr) ans += query1(1, 1, cnt, pl, pr);

            cout << ans << endl;
        }
    }

    return 0;
}
