#include <iostream>
#define endl '\n'
using namespace std;

const int MAXN = 100000;

int d[MAXN + 5];
int tree[4 * MAXN + 5];
long long points[MAXN + 5];

void update(int v, int l, int r, int p, int val)
{
    if (r < p or p < l) return;
    if (l == r)
    {
        tree[v] += val;
        return;
    }

    int mid = (l + r) / 2;
    update(2 * v, l, mid, p, val);
    update(2 * v + 1, mid + 1, r, p, val);
    tree[v] = tree[2 * v] + tree[2 * v + 1];
}

int query(int v, int l, int r, int L, int R)
{
    if (r < L or R < l) return 0;
    if (L <= l and r <= R) return tree[v];

    int mid = (l + r) / 2;
    return query(2 * v, l, mid, L, R) + query(2 * v + 1, mid + 1, r, L, R);
}

int main()
{
    ios :: sync_with_stdio(false);
    cin.tie(NULL); cout.tie(NULL);

    int n, q;
    cin >> n >> q;

    while (q--)
    {
        int type;
        cin >> type;

        if (type == 1)
        {
            int p;
            cin >> p;
            update(1, 1, n, p, +1);
        }
        else if (type == 2)
        {
            int p;
            cin >> p;
            update(1, 1, n, p, -1);
        }
        else if (type == 3)
        {
            int c, a;
            cin >> c >> a;
            points[c] += a;
        }
        else
        {
            int l, r;
            cin >> l >> r;

            int t = query(1, 1, n, 1, l - 1);
            if (t % 2 == 1) cout << points[l] << endl;
            else cout << 0 << endl;
        }
    }

    return 0;
}
