#include <iostream>
#include <iomanip>
#define endl '\n'
using namespace std;

const int MAXN = 3000000;
const int MAXA = 10000000;

int n, k;
int a[MAXN + 5];
long long pref[MAXN + 5];
long double mxsum[MAXN + 5];

long double solve(long double av)
{
    long double mx = 0.0;
    for (int i = 1; i <= n; ++ i)
    {
        mx = max(a[i] - av, mx + a[i] - av);
        mxsum[i] = mx;
    }

    long double ret = pref[k] - k * av;
    for (int i = k; i <= n; ++ i)
    {
        long double sum = pref[i] - pref[i - k] - k * av;
        ret = max(ret, max(sum, sum + mxsum[i - k]));
    }
    return ret;
}

int main()
{
    ios :: sync_with_stdio(false);
    cin.tie(NULL); cout.tie(NULL);

    cin >> n >> k;

    for (int i = 1; i <= n; ++ i)
    {
        cin >> a[i];
        pref[i] = pref[i - 1] + a[i];
    }

    long double eps = 0.0001;
    long double l = 1.0, r = 1.0 * (MAXA + 1), mid;
    while (r - l > eps)
    {
        mid = (l + r) / 2;

        long double f = solve(mid);

        if (f >= 0.0) l = mid;
        else r = mid;
    }

    cout << fixed << setprecision(3) << l << endl;

    return 0;
}
