#include <iostream>
#define endl '\n'
using namespace std;

const int MAXN = 300000;
const int MAXA = 1000000;

int n, k;
int a[MAXN + 5];
long long pref[MAXN + 5];
long double mxsum[MAXN + 5];

long double solve(long double av)
{
    mxsum[0] = 0.0;
    long double mx = 0.0;
    for (int i = 1; i <= n; ++ i)
    {
        mx = max((long double)(a[i] - av), mx + a[i] - av);
        mxsum[i] = mx;
    }

    long double ret = pref[k] - k * av;
    for (int i = k; i <= n; ++ i)
    {
        long double sum = pref[i] - pref[i - k] - k * av;
        ret = max(ret, max(sum, sum + mxsum[i - k]));
    }
    return ret;
}

int main()
{
    ios :: sync_with_stdio(false);
    cin.tie(NULL); cout.tie(NULL);

    cin >> n >> k;

    for (int i = 1; i <= n; ++ i)
    {
        cin >> a[i];
        pref[i] = pref[i - 1] + a[i];
    }

    long double eps = 0.001;
    long double l = 1.0, r = 1.0 * MAXA;
    while (r - l >= eps)
    {
        long double mid1 = l + 1.0 * (r - l) / 3;
        long double mid2 = r - 1.0 * (r - l) / 3;

        long double f1 = solve(mid1);
        long double f2 = solve(mid2);

        if (f2 >= 0.0) l = mid2;
        else if (f1 < 0.0) r = mid1;
        else
        {
            l = mid1;
            r = mid2;
        }
    }

    cout << l << endl;

    return 0;
}
