#include <iostream>
#define endl '\n'
using namespace std;

const int MAXN = 300000;
const int MAXA = 1000000;

int n, k;
int a[MAXN + 5];
long long pref[MAXN + 5];

long double solve(long double av)
{
    int l = 1, r = k - 1;
    long double ret = 1.0 * pref[k] - k * av;
    long double sum = 1.0 * pref[k - 1] - (k - 1) * av;
    while (r < n)
    {
        r++;
        sum += a[r] - av;
        while (r < n and a[r + 1] - av > 0)
        {
            r++;
            sum += a[r] - av;
        }
        ret = max(ret, sum);
        while (r - l + 1 > k and a[l] - av <= 0)
        {
            sum -= a[l] - av;
            l++;
        }
        ret = max(ret, sum);
    }
    return ret;
}

int main()
{
    ios :: sync_with_stdio(false);
    cin.tie(NULL); cout.tie(NULL);

    cin >> n >> k;

    for (int i = 1; i <= n; ++ i)
    {
        cin >> a[i];
        pref[i] = pref[i - 1] + a[i];
    }

    long double eps = 0.0001;
    long double l = 1.0, r = (long double)(1.0 * MAXA);
    while (r - l > eps)
    {
        long double mid1 = l + 1.0 * (r - l) / 3;
        long double mid2 = r - 1.0 * (r - l) / 3;

        long double f1 = solve(mid1);
        long double f2 = solve(mid2);

        if (f2 >= 0) l = mid2;
        else if (f1 < 0) r = mid1;
        else
        {
            l = mid1;
            r = mid2;
        }
    }

    cout << l << endl;

    return 0;
}
