#include<iostream>
#include<vector>
using namespace std;

const int MAXN=1e5;

long long a[MAXN], bit[MAXN+1];
long long seg[MAXN][2];
long long pref[MAXN+1];

void Add(int n, int idx, int x)
{
    while(idx<=n)
    {
        bit[idx]+=x;
        idx+=idx&-idx;
    }

    return;
}

int GetSum(int idx)
{
    int sum=0;
    while(idx>0)
    {
        sum+=bit[idx];
        idx-=idx&-idx;
    }

    return sum;
}

void Process(int n)
{
    vector<int> v;
    v.push_back(0);

    long long curr=0;
    for(int i=0; i<n; i++)
    {
        int cnt=GetSum(i);
        if(cnt!=curr)
        {
            v.push_back(i);
            curr=cnt;
        }
    }
    v.push_back(n);

    int m=v.size();
    for(int i=1; i<m; i++)
    {
        int l=v[i-1], r=v[i];
        for(int j=l; j<r; j++)
        {
            seg[j][0]=a[j];
            if(j!=l)
            {
                seg[j][0]=max(seg[j][0], seg[j-1][0]);
            }
        }

        for(int j=r-1; j>=l; j--)
        {
            seg[j][1]=a[j];
            if(j!=r-1)
            {
                seg[j][1]=max(seg[j][1], seg[j+1][1]);
            }
        }

        int maxnum=0;
        for(int i=l; i<r; i++)
        {
            maxnum=max((long long)maxnum, a[i]);
        }

        if(i%2==0)
        {
            pref[i-1]=maxnum;
        }
        else
        {
            pref[i-1]=0;
        }

        if(i!=1)
        {
            pref[i-1]+=pref[i-2];
        }
    }

    return;
}

int main()
{
    ios_base::sync_with_stdio(0);
    cin.tie(0);

    int n, q;
    cin >> n >> q;

    for(int i=1; i<=n; i++)
    {
        bit[i]=0;
        a[i]=0;
    }

    bool processed=false;
    while(q--)
    {
        int t;
        cin >> t;

        if(t==1)
        {
            int p;
            cin >> p;

            Add(n, p, 1);
        }
        else if(t==2)
        {
            int p;
            cin >> p;

            Add(n, p, -1);
        }
        else if(t==3)
        {
            int c, x;
            cin >> c >> x;

            a[c-1]+=x;
        }
        else if(t==4)
        {
            if(!processed)
            {
                Process(n);
                processed=true;
            }

            int l, r;
            cin >> l >> r;
            l--, r--;

            int posl=GetSum(l), posr=GetSum(r);

            long long res=0;
            if(posl+1<posr)
            {
                res+=pref[posr-1]-pref[posl];
            }

            if(posl%2==1)
            {
                res+=seg[l][1];
            }
            else if(posr%2==1)
            {
                res+=seg[r][0];
            }

            cout << res << "\n";
        }
    }

    return 0;
}
/*
10 15
1 4
3 3 7
3 4 1
3 5 8
3 6 5
1 1
3 10 3
3 9 2
3 8 9
1 8
3 9 8
1 7
3 2 6
2 1
4 2 9
*/
