#include<iostream>
using namespace std;

const int MAXN=1e5;

int a[MAXN], bit[MAXN+1];

void Add(int n, int idx, int x)
{
    while(idx<=n)
    {
        bit[idx]+=x;
        idx+=idx&-idx;
    }

    return;
}

int GetSum(int idx)
{
    int sum=0;
    while(idx>0)
    {
        sum+=bit[idx];
        idx-=idx&-idx;
    }

    return sum;
}

int main()
{
    ios_base::sync_with_stdio(0);
    cin.tie(0);

    int n, q;
    cin >> n >> q;

    for(int i=1; i<=n; i++)
    {
        bit[i]=0;
        a[i]=0;
    }

    while(q--)
    {
        int t;
        cin >> t;

        if(t==1)
        {
            int p;
            cin >> p;

            Add(n, p, 1);
        }
        else if(t==2)
        {
            int p;
            cin >> p;

            Add(n, p, -1);
        }
        else if(t==3)
        {
            int c, x;
            cin >> c >> x;

            a[c-1]+=x;
        }
        else if(t==4)
        {
            int l, r;
            cin >> l >> r;

            if(GetSum(l-1)%2==1)
            {
                cout << a[l-1] << "\n";
            }
            else
            {
                cout << 0 << "\n";
            }
        }
    }

    return 0;
}
/*
10 20
1 4
3 3 7
3 4 1
3 5 8
3 6 5
4 5 5
1 1
4 10 10
3 10 3
3 9 2
3 8 9
1 8
4 10 10
4 10 10
3 9 8
1 7
3 2 6
4 10 10
2 1
4 10 10
*/
