#include<iostream>
#include<deque>
#include<stack>
#include<iomanip>
using namespace std;

const int MAXN=3e5;

int a[MAXN];

bool CanAverage(int n, int k, double x)
{
    deque<double> dq;
    stack<double> st;
    double sumdq=0, sumst=0;
    int sts=0;
    for(int i=0; i<k; i++)
    {
        dq.push_back(a[i]);
        sumdq+=a[i];
    }

    if(sumdq/k>=x)
    {
        return true;
    }

    for(int i=k; i<n; i++)
    {
        dq.push_back(a[i]);
        sumdq+=a[i];

        st.push(dq.front());
        sumst+=dq.front(), sumdq-=dq.front();
        sts++;

        dq.pop_front();

        if(sumst/st.size()<x)
        {
            while(!st.empty())
            {
                st.pop();
            }
            sumst=0, sts=0;
        }

        if((sumdq+sumst)/(k+sts)>=x)
        {
            return true;
        }
    }

    return false;
}

int main()
{
    ios_base::sync_with_stdio(0);
    cin.tie(0);

    int n, k;
    cin >> n >> k;

    for(int i=0; i<n; i++)
    {
        cin >> a[i];
    }

    double l=1, r=1e6, diff=0.00001, ans;
    while(r-l>diff)
    {
        double mid=l+(r-l)/2;
        if(CanAverage(n, k, mid))
        {
            ans=mid;
            l=mid;
        }
        else
        {
            r=mid;
        }
    }

    cout << fixed << setprecision(4) << ans << "\n";

    return 0;
}
