#include<iostream>
#include<iomanip>
using namespace std;

const int MAXN=3e5;

double a[MAXN];
double b[MAXN], maxsum[MAXN];

bool CanAverage(int n, int k, double x)
{
    double sum=0;
    for(int i=0; i<n; i++)
    {
        b[i]=a[i]-x;

        if(i<k)
        {
            sum+=b[i];
        }

        maxsum[i]=max(0.0, b[i]);
        if(i!=0)
        {
            maxsum[i]=max(maxsum[i], maxsum[i-1]+b[i]);
        }
    }

    if(sum>=0)
    {
        return true;
    }

    for(int i=k; i<n; i++)
    {
        sum+=b[i]-b[i-k];

        if(sum+maxsum[i-k]>=0)
        {
            return true;
        }
    }

    return false;
}

int main()
{
    ios_base::sync_with_stdio(0);
    cin.tie(0);

    int n, k;
    cin >> n >> k;

    for(int i=0; i<n; i++)
    {
        cin >> a[i];
    }

    double l=1, r=1e6, diff=0.001, ans=0;
    while(r-l>diff)
    {
        double mid=l+(r-l)/2;
        if(CanAverage(n, k, mid))
        {
            //cout << mid << "\n";
            ans=mid;
            l=mid;
        }
        else
        {
            r=mid;
        }
    }

    //cout << ans << "\n";
    cout << fixed << setprecision(4) << ans << "\n";

    return 0;
}

//sum/cnt
//y+cnt*x/cnt
//y/cnt+x
