/**
 ____ ____ ____ ____ ____ ____
||l |||e |||i |||n |||a |||d ||
||__|||__|||__|||__|||__|||__||
|/__\|/__\|/__\|/__\|/__\|/__\|

**/

#include<bits/stdc++.h>
#define endl '\n'

using namespace std;
typedef long long ll;

void speed()
{
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    cout.tie(NULL);
}

const int maxn = 3e5 + 10;
struct point
{
    double x, y;

    point (ll _x, ll _y)
    {
        x = _x;
        y = _y;
    }

};

double signed_area(point p1, point p2, point p3)
{
    double area = (p2.x - p1.x) * (p1.y + p2.y) +
                    (p3.x - p2.x) * (p2.y + p3.y) +
                    (p1.x - p3.x) * (p3.y + p1.y);
    return area;
}

int orientation(point p1, point p2, point p3)
{
    double area = signed_area(p1, p2, p3);
    if (area > 0)
    return 1;
    if (area < 0)
        return -1;
    return 0;
}



int n, k;
ll a[maxn], pref[maxn];
void solve()
{
    cin >> n >> k;
    for (int i = 1; i <= n; i ++)
        cin >> a[i], pref[i] = pref[i - 1] + a[i];

    vector < point > pt;
    pt.push_back({0, 0});
    for (int i = 1; i <= n; i ++)
    {
        pt.push_back({i, pref[i]});
    }

    vector < point > upper_hull, lower_hull;

    point st = {0, 0}, en = pt[n];
    lower_hull.push_back(st);
    upper_hull.push_back(st);

    for (int i = 1; i < n; i ++)
    {
        point p = pt[i];
        if (orientation(st, en, p) == -1)
        {
            while(upper_hull.size() > 1)
            {
                point p1 = upper_hull[(int)(upper_hull.size()) - 2], p2 = upper_hull.back();
                if (orientation(p1, p2, p) <= 0)
                    upper_hull.pop_back();
                else
                    break;
            }

            upper_hull.push_back(p);
        }
        else
        if (orientation(st, en, p) == 1)
        {
            while(lower_hull.size() > 1)
            {
                point p1 = lower_hull[(int)(lower_hull.size()) - 2], p2 = lower_hull.back();
                if (orientation(p1, p2, p) >= 0)
                    lower_hull.pop_back();
                else
                    break;
            }

            lower_hull.push_back(p);
        }
    }

    upper_hull.push_back(en);
    lower_hull.push_back(en);


    int idx = 0;
    double ans = 0.0;
    for (int i = 0; i < lower_hull.size(); i ++)
    {
        while(idx < upper_hull.size() && upper_hull[idx].x - lower_hull[i].x < k)
            idx ++;

            ///cout << lower_hull[i].x << " " << idx << endl;
        if (idx == upper_hull.size())
            break;

        double slope = (upper_hull[idx].y - lower_hull[i].y) / (upper_hull[idx].x - lower_hull[i].x);
        if (slope > ans)
        {

            ans = slope;
        }
    }

    printf("%0.4f\n", ans);
}

int main()
{
    solve();
    return 0;
}

