#include <stdio.h>
#include <stdint.h>

typedef struct Snowman Snowman;
struct Snowman {
	int64_t mass;
	Snowman *prev;
};

int64_t n;
Snowman snowmen[1000001];

void add(int64_t i, int64_t p, int64_t m) {
	snowmen[i].prev = &snowmen[p];
	snowmen[i].mass = snowmen[i].prev->mass + m;
}

void remove(int64_t i, int64_t p) {
	snowmen[i].prev = snowmen[p].prev;
	snowmen[i].mass = snowmen[p].prev->mass;
}

int main() {
	scanf("%d", &n);
	snowmen[0].mass = 0;
	snowmen[0].prev = NULL;
	for (int64_t i = 1; i <= n; ++i) {
		int64_t p;
		int64_t m;
		scanf("%d%lld", &p, &m);
		if (m) add(i, p, m);
		else remove(i, p);
	}
	
	int64_t ans = 0;
	for (int64_t i = 1; i <= n; ++i) {
		ans += snowmen[i].mass;
	}
	printf("%lld\n", ans);
}