#include <stdio.h>
#include <stdint.h>

typedef struct Snowman Snowman;
struct Snowman {
	int64_t mass;
	Snowman *prev;
};

int n;
Snowman snowmen[1000001];

void add(int i, int p, int64_t m) {
	snowmen[i].prev = &snowmen[p];
	snowmen[i].mass = snowmen[i].prev->mass + m;
}

void remove(int i, int p) {
	snowmen[i].prev = snowmen[p].prev;
	snowmen[i].mass = snowmen[p].prev->mass;
}

int main() {
	scanf("%d", &n);
	snowmen[0].mass = 0;
	snowmen[0].prev = NULL;
	for (int i = 1; i <= n; ++i) {
		int p;
		int64_t m;
		scanf("%d%lld", &p, &m);
		if (m) add(i, p, m);
		else remove(i, p);
	}
	
	int ans = 0;
	for (int i = 1; i <= n; ++i) {
		ans += snowmen[i].mass;
	}
	printf("%d\n", ans);
}