#include <iostream>
#include <vector>
//#include <stack>
using namespace std;
//ios_base::sync_with_stdio(false);
//cin.tie(NULL);
struct list {
	struct list *next, *prev;
	int value_snowball;
	int weight;
};
struct list *PushFront(struct list* snowman, int new_snowball)
{
	struct list *new_node = new struct list ();
	new_node->value_snowball = new_snowball;
	if (snowman == NULL)
		new_node->weight = new_snowball;
	else 
	{
		new_node->next = snowman;
		snowman->prev = new_node;
		new_node->weight = new_node->next->weight + new_snowball;
	}
	return new_node;
}
struct list *PushBack(struct list* snowman, int new_snowball)
{
	struct list *new_node = new struct list();
	new_node->value_snowball = new_snowball;
	new_node->weight = new_snowball;
	struct list* curr = snowman;
	if (snowman == NULL)
		return new_node;
	else
	{
		while (curr->next != NULL)
			curr = curr->next;
		curr->next = new_node;
		new_node->prev = curr;
		while(curr != NULL)
			curr->weight = curr->weight + new_snowball, curr = curr->prev;
	}
	return snowman;
}
struct list *PopFront(struct list* snowman)
{
	if (snowman == NULL)
		return NULL;
	struct list *old_node = snowman;
	snowman = snowman->next;
	snowman->prev = NULL;
	delete old_node;
	return snowman;
}
vector<struct list*> clone(vector<struct list*> snowmans, int index, int original_snowman, int new_snowball)
{
	struct list *curr = snowmans[original_snowman];
	struct list *cloning_snowman = NULL;
	while (curr != NULL)
	{
		cloning_snowman = PushBack(cloning_snowman, curr->value_snowball);
		curr = curr->next;
	}
	if (new_snowball > 0)
		cloning_snowman = PushFront(cloning_snowman, new_snowball);
	else
		cloning_snowman = PopFront(cloning_snowman);
	snowmans.push_back(cloning_snowman);
	return snowmans;
}

int main()
{
	ios_base::sync_with_stdio(false);
	cin.tie(NULL);
	int  N, original_snowman, new_snowball, res = 0;
	vector<struct list*> snowmans;
	cin >> N;
	struct list *curr = PushFront(NULL, 0);
	snowmans.push_back(curr);
	for (int i = 1; i < N + 1; i++)
	{
		cin >> original_snowman >> new_snowball;

		snowmans = clone(snowmans, i, original_snowman, new_snowball);
		res += snowmans[i]->weight;
	}
	cout << res;

	return 0;
}