#include <iostream>

#define endl '\n'

using namespace std;

const int MAXN = 1e4 + 3;
int nums[MAXN];

// dp(i, 0) - even
// dp(1, 1) - odd
int64_t dp[MAXN][2];

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;

    for (int i = 0; i < n; ++i) {
        cin >> nums[i];
    }

    for (int i = 0; i < n; ++i) {
        bool is_curr_even = (nums[i] % 2 == 0);

        if (is_curr_even) {
            dp[i][0] = 1ll;
        } else {
            dp[i][1] = 1ll;
        }

        if (i == 0) {
            continue;
        }

        if (is_curr_even) {
            dp[i][0] += dp[i - 1][0];
            dp[i][0] += dp[i - 1][1];
        } else {
            dp[i][0] += dp[i - 1][0];
            dp[i][1] += dp[i - 1][1];
        }
    }

    int64_t res = 0;
    for (int i = 0; i < n; ++i) {
        res += dp[i][0];
    }

    cout << res << endl;

return 0;
}
