#include <iostream>
#include <stack>
#include <vector>

#define endl '\n'

using namespace std;

const int MAXN = 1e6 + 3;
int weights[MAXN];
pair<int, int> pos[MAXN];
vector<vector<int>> snowballs;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;

    weights[0] = 0;
    pos[0] = {-1, -1};

    for (int i = 1; i <= n; ++i) {
        int p, m;
        cin >> p >> m;

        weights[i] = weights[p];

        int seq = pos[p].first;
        int ind = pos[p].second;

        if (m == 0) {
            weights[i] -= snowballs[seq][ind];
            --ind;
        } else {
            weights[i] += m;

            if (seq == -1 or ind + 1 < (int) snowballs[seq].size()) {
                snowballs.push_back({});
                int new_seq = (int) snowballs.size() - 1;

                for (int j = 0; j <= ind; ++j) {
                    snowballs[new_seq].push_back(snowballs[seq][j]);
                }

                seq = new_seq;
            }

            snowballs[seq].push_back(m);
            ++ind;
        }

        /*cout << i << " -> Element witn index " << ind << " in seq: ";
        if (seq != -1) {
            for (int nz : snowballs[seq]) {
                cout << nz << " ";
            }
        }
        cout << endl;*/

        pos[i] = {seq, ind};
    }

    int total_weight = 0;
    for (int i = 0; i <= n; ++i) {
        total_weight += weights[i];
    }

    cout << total_weight << endl;

return 0;
}
