#include <iostream>
#include <string>
#include <cstdio>

using namespace std;

typedef struct snowman{
    int no;
    int snowballs;
    int weight;
    int top_ball;
    struct snowman *next;
} snowman_t;

snowman_t *init(size_t size){
    snowman_t *snowman_list = new snowman_t;

    snowman_t *current = snowman_list;
    for(int i = 0; i < size; ++i){
        current->next = new snowman_t;
        current->weight = 0;
        current = current->next;
    }
    current->next = NULL;
    return snowman_list;
}

snowman_t *add(snowman_t *snowman_list, size_t size, int no, int weight){
    snowman_t *new_snowman = new snowman_t;
    new_snowman->no = no;
    new_snowman->snowballs = ++snowman_list->snowballs;
    new_snowman->weight = snowman_list->weight + weight;
    new_snowman->top_ball = weight;
    new_snowman->next = snowman_list;
    return new_snowman;
}

int get_w(snowman_t *snowman_list, size_t size, int index){
    snowman_t *current = snowman_list;

    for(int i = 0; i < size - index; ++i){
        current = current->next;
    }
    return current->weight - current->top_ball;
}

snowman_t *add_diff(snowman_t *snowman_list, size_t size, int index, int old_index){
    snowman_t *current = snowman_list;

    //cout << index << old_index << endl;
    for(int i = 0; i < index - old_index; ++i){
        current = current->next;
    }
    //cout << "After current\n";
    snowman_t *new_snowman = new snowman_t;
    new_snowman->no = index + 1;
    new_snowman->snowballs = --current->snowballs;
    new_snowman->weight = current->weight - current->top_ball;
    //cout << "Before ifs\n";
    if(current->next != NULL)
        new_snowman->top_ball = current->next->top_ball;
    else{
        new_snowman->top_ball = 0;
        new_snowman->weight = 0;
        new_snowman->snowballs = 0;
    }
    new_snowman->next = snowman_list;
    return new_snowman;
}

void print_snow(snowman_t *snowman_list){
    snowman_t *current = snowman_list;
    while(current != NULL){
        cout << "Snowman: " << current->no << "; weight: " << current->weight << endl;
        current = current->next;
    }
}

long long all_w(snowman_t *snowman_list){
    snowman_t *current = snowman_list;
    long long sum = 0;
    while(current != NULL){
        sum += current->weight;
        current = current->next;
    }
    return sum;
}

int main(){
    int n_snowmen, all_kg = 0;
    int snowman, weight;

    //unordered_map<unsigned unsigned short, short> snowmen;

    cin >> n_snowmen;
    snowman_t *snowman_list = init(n_snowmen);


    scanf("%d %d", &snowman, &weight);
    snowman_list->no = 1;
    snowman_list->snowballs = 1;
    snowman_list->top_ball = weight;
    snowman_list->weight = weight;
    snowman_list->next = NULL;

    snowman_t *current = snowman_list;
    snowman_t *prev = current;

    //cout << snowman_list->no;
    for(int i = 1; i < n_snowmen; ++i){
        scanf("%d %d", &snowman, &weight);
        if(weight == 0){
            //arr[] = arr[snowman];
            //cout << n_snowmen << snowman << "   " << snowman_list->weight << endl;
            //int w = get_w(snowman_list, i, snowman);
            //cout << "after w (" << w << ")";
            //snowman_list = add_diff(snowman_list, n_snowmen, i + 1, w);
            //cout << i << snowman << endl;
            snowman_list = add_diff(snowman_list, n_snowmen, i, snowman);
            //cout << "   " << snowman_list->weight << endl;
        } else {
            //snowmen.insert({snowman, weight});
            /*
            current->no = i + 1;
            current->snowballs = ++prev->snowballs;
            current->weight = prev->weight + weight;
            prev = current;
            current = current->next;
            */
            snowman_list = add(snowman_list, n_snowmen, i + 1, weight);
        }

    }
    //cout << snowman_list->weight << endl;
    //cout << snowman_list->next->weight << endl;
    //print_snow(snowman_list);

    /*
    for(int i = 0; i < n_snowmen; ++i){
        scanf("%d %d", &snowman, &weight);
        if(weight == 0){
            arr[] = arr[snowman];
        } else {
            //snowmen.insert({snowman, weight});
            arr[snowman] = weight;
        }
    }
    */

    cout << all_w(snowman_list);

    return 0;
}
