#include <stdio.h>
#include <malloc.h>

struct snowball
{
    int mass;
    struct snowball* next;
};

struct snowman
{
    int num;
    struct snowball* snball;
    struct snowman* next;
};

int res = 0;

void get_snballs_mass(struct snowman* snman)
{
    while(snman->snball != NULL)
    {
        res += snman->snball->mass;
        snman->snball = snman->snball->next;
    }
};

struct snowball* add_snowball(struct snowman* snman, int m)
{
    struct snowball* new_ball = malloc(sizeof*new_ball);
    new_ball->mass = m;
    new_ball->next = snman->snball;
    return new_ball;
};

struct snowball* remove_snowball(struct snowman* snman)
{
    struct snowball* temp = snman->snball;
    snman->snball = snman->snball->next;
    free(temp);
    return snman->snball;
};

struct snowman* copy_snowman(struct snowman* snman)
{
    struct snowman* copy = malloc(sizeof*copy);
    while(snman->snball)
    {
        copy->snball = add_snowball(snman, snman->snball->mass);
        snman->snball = snman->snball->next;
    }
    return copy;
};

struct snowman* add_snowman(struct snowman* snmen, int p, int m)
{
    if(snmen == NULL)
    {
        struct snowman* new_snman = malloc(sizeof*new_snman);
        new_snman->snball = (struct snowball*)malloc(sizeof*new_snman->snball);
        new_snman->snball->mass = m;
        new_snman->snball->next = NULL;
        new_snman->next = NULL;
        res += m;
        return new_snman;
    }
    while(snmen)
    {
        if(snmen->num == p)
        {
            struct snowman* new_snman = copy_snowman(snmen);
            if(m > 0)
                new_snman->snball = add_snowball(new_snman, m);
            else
                new_snman->snball = remove_snowball(new_snman);
            new_snman->next = snmen;
            get_snballs_mass(new_snman);
            return new_snman;
        }
        snmen = snmen->next;
    }
};

int snowmen_mass(int N)
{
    struct snowman* snmen = NULL;
    int p = 0, m = 0, tmpn = N;
    for(; N > 0; N--)
    {
        scanf("%d", &p);
        scanf("%d", &m);
        snmen = add_snowman(snmen, p, m);
        snmen->num = tmpn - N + 1;
        printf("%d %d\n", res, snmen->num);
    }
}

int main()
{
    int n = 0;
    scanf("%d", &n);
    snowmen_mass(n);
    printf("%d", res);
    return 0;
}
