#include <stdio.h>
#include <stdlib.h>

#define ll long long

typedef struct{
    int x, y;
} point_t;

point_t* point_init(int x, int y){
    point_t* result = (point_t*) malloc(sizeof(point_t));
    result->x = x;
    result->y = y;
    return result;
}

ll square[20000] = {0};

ll compute(point_t* p1, point_t* p2){
    ll x_diff = p1->x > p2->x ? p1->x - p2->x : p2->x - p1->x;
    if(square[x_diff] == 0) square[x_diff] = x_diff * x_diff;
    ll y_diff = p1->y > p2->y ? p1->y - p2->y : p2->y - p1->y;
    if(square[y_diff] == 0) square[y_diff] = y_diff * y_diff;
    return square[x_diff] + square[y_diff];
}

int main(){
    int N;
    scanf("%d", &N);
    ll result = 0;
    point_t* points[N];
    for(int i = 0; i < N; i++){
        int x, y;
        scanf("%d %d", &x, &y);
        points[i] = point_init(x, y);
    }
    for(int i = 0; i < N; i++){
        for(int j = i + 1; j < N; j++){
            result += compute(points[i], points[j]);
        }
    }
    printf("%lld", result);
    return 0;
}
