#include <stdio.h>
#include <stdlib.h>

#define ll long long

typedef struct{
    ll sum, last, last_index;
} pair_t;

pair_t* pair_init(ll sum, ll last, ll last_index){
    pair_t *result = (pair_t*) malloc(sizeof(pair_t));
    result->sum = sum;
    result->last = last;
    result->last_index = last_index;
    return result;
}

pair_t* pair_copy(pair_t *p){
    return pair_init(p->sum, p->last, p->last_index);
}

int main(){
    ll N;
    scanf("%lld", &N);
    pair_t *input[N + 1];
    input[0] = pair_init(0, 0, 0);
    /// [sum, m, p];
    ll result = 0;
    for(ll i = 1; i <= N; i++){
        ll p, m;
        scanf("%lld %lld", &p, &m);
        input[i] = pair_copy(input[p]);
        if(m > 0){
            input[i]->sum = input[i]->sum + m;
            input[i]->last = m;
            input[i]->last_index = p;
        }else if(m == 0){
            input[i]->sum = input[i]->sum - input[i]->last;
            input[i]->last = input[input[i]->last_index]->last;
            input[i]->last_index = input[input[i]->last_index]->last_index;
        }
        result += input[i]->sum;
    }
    printf("%lld", result);
    return 0;
}


