#include <iostream>
#include <algorithm>
#include <vector>
#define endl '\n'
using namespace std;

vector<int> divisors(int n) {
    vector<int> output;
    output.push_back(1);

    for (int i = 2; i <= n/2; i++) {
        if (n % i == 0) {
            output.push_back(i);
        }
    }

    return output;
}

int binarySearch(int arr[], int l, int r, int key) {
    int mid;
    int output = -1;

    while (l <= r) {
        mid = (l + r)/2;
        if (key == arr[mid]) {
            output = mid;
            l = r + 1;
        } else if (key > arr[mid]) {
            l = mid + 1;
        } else {
            r = mid - 1;
        }
    }

    return output;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int ans = 0;

    int N;
    cin >> N;

    int arr[N];
    vector<int> data[N];
    vector<int> tempDivisors;

    for (int i = 0; i < N; i++) {
        cin >> arr[i];
    }

    sort(arr, arr + N);

    for (int i = 0; i < N; i++) {
        tempDivisors = divisors(arr[i]);

        if (tempDivisors[0] != arr[i]) {
            for (auto p: tempDivisors) {
                int bs = binarySearch(arr, 0, i - 1, p);

                if (bs != -1) {
                    data[bs].push_back(arr[i]);
                }
            }
        }
    }

    for (int i = 0; i < N; i++) {
        for (int j = 0; j < data[i].size(); j++) {
            int bs = binarySearch(arr, i + 1, N - 1, data[i][j]);
            ans += data[bs].size();
        }
    }

    cout << ans << endl;

    return 0;
}
