#include<iostream>
#include<algorithm>
#include<vector>
using namespace std;

const int mnogo = 1000000007;

int broiDni;
int cenaPrestoi;

int ceniPetrol[1000010];

struct DanniZaPechalba{
    int pechalba;
    int otKoi;
    int doKoi;
};

vector<DanniZaPechalba> pechalbi;

bool koiEPoNapred(DanniZaPechalba a, DanniZaPechalba b){
    return a.pechalba > b.pechalba;
}

bool izpolzvanLiE[1000010];

int naToziDenKakvoPravim[512];

int naiMnSpecheleno = -mnogo;

void izchisliZTakavaKombinaciq(){

    int obshtoSpech = 0;

    int vMomentaSahranqvame = 0;

    for(int i = 0; i < broiDni; i++){
        obshtoSpech += naToziDenKakvoPravim[i]*ceniPetrol[i];
        if(naToziDenKakvoPravim[i] == -1){
            vMomentaSahranqvame++;
        }else{
            if(naToziDenKakvoPravim[i] == 1){
                vMomentaSahranqvame--;
            }
        }

        obshtoSpech -= vMomentaSahranqvame*cenaPrestoi;
    }

    if(vMomentaSahranqvame == 0){
        naiMnSpecheleno = max(naiMnSpecheleno, obshtoSpech);
    }
}

void napravigolqmaPechalba(int naKoiDenSam){
    if(naKoiDenSam == broiDni){
        izchisliZTakavaKombinaciq();
        return ;
    }

    naToziDenKakvoPravim[naKoiDenSam] = -1;
    napravigolqmaPechalba(naKoiDenSam + 1);

    naToziDenKakvoPravim[naKoiDenSam] = 1;
    napravigolqmaPechalba(naKoiDenSam + 1);

    naToziDenKakvoPravim[naKoiDenSam] = 0;
    napravigolqmaPechalba(naKoiDenSam + 1);
}

int main(){

    cin>>broiDni>>cenaPrestoi;

    for(int i = 0; i < broiDni; i++){
        cin>>ceniPetrol[i];
    }

    if(broiDni > 10){
        for(int i = 0; i < broiDni; i++){
            for(int j = i + 1; j < broiDni; j++){
                int tukaPechalba = ceniPetrol[j] - ceniPetrol[i] - (j - i)*cenaPrestoi;

                if(tukaPechalba > 0){
                    pechalbi.push_back({tukaPechalba, i, j});
                }
            }
        }

        sort(pechalbi.begin(), pechalbi.end(), koiEPoNapred);

        int specheleno = 0;

        for(int i = 0; i < (int)pechalbi.size(); i++){
            if(izpolzvanLiE[pechalbi[i].otKoi] == false && izpolzvanLiE[pechalbi[i].doKoi] == false){
                specheleno += pechalbi[i].pechalba;
                izpolzvanLiE[pechalbi[i].otKoi] = true;
                izpolzvanLiE[pechalbi[i].doKoi] = true;
            }
        }

        cout<<specheleno<<endl;
    }else{

        napravigolqmaPechalba(0);

        cout<<naiMnSpecheleno<<endl;
    }

    return 0;
}
