#include <iostream>
#include <vector>
#include <algorithm>
#include <numeric>

using namespace std;

int main() {
    long N;
    long S;

    cin >> N >> S;
    std::vector<long> P;
    P.reserve(N);

    for (long i = 0; i < N; ++i) {
        int num;
        cin >> num; 
        P.push_back(num);
    }

    sort(P.begin(), P.end());

    const int storage_price = P.size() * S;
    int max_profit = 0;
    for (int i = P.size() / 2; i < P.size() - 1; ++i) {
        int spent_money = accumulate(P.begin(), P.begin() + i, 0);
        int acquired_money = accumulate(P.begin() + i + 1, P.end(), 0);
        int profit = acquired_money - spent_money - storage_price;
        if (profit > max_profit) {
            // std::cout << "Max spent_money: " << spent_money << '\n';
            // std::cout << "Max acquired_money: " << acquired_money << '\n';
            // std::cout << "Max storage_price: " << storage_price << '\n';
            max_profit = profit;
        }
    }
    std::cout << max_profit;
    return 0;
}