#include <iostream>
#include <stack>

using namespace std;

const long ABORT = 0;
const long OK = 1;

class Wheel
{
private:
    char W[25];
    long Current = 0;
    long Letters[26];
    long K;

public:
    Wheel(long IK)
    {
        K = IK;
        for (long i = 0; i < 25; i++)
        {
            W[i] = '?';
        }
        for (long i = 0; i < 26; i++)
        {
            Letters[i] = 0;
        }
    }

    long Write(char A)
    {
        if (W[Current] != '?' && (W[Current] != A))
        {
            return ABORT;
        }

        if (W[Current] != A)
        {
            Letters[A - 'A']++;
        }

        if (Letters[A - 'A'] > 1)
        {
            return ABORT;
        }

        W[Current] = A;
        return OK;
    }

    void Print()
    {
        stack <char> T;
        for (long i = 0; i < K; i++)
        {
            Current++;
            Current %= K;
            T.push(W[Current]);
        }

        for (long i = 0; i < K; i++)
        {
            cout << T.top();
            T.pop();
        }
    }

    long Read()
    {
        return W[Current];
    }

    void Spin(long Times)
    {
        Current += Times;
        Current %= K;
    }
};

int main()
{
    long N;
    long K;

    long S;
    char R;

    cin >> N;
    cin >> K;

    Wheel W(N);

    long Status = OK;

    for (long i = 0; i < K; i++)
    {
        cin >> S;
        cin >> R;

        W.Spin(S);
        if (W.Write(R) == ABORT)
        {
            Status = ABORT;
        }
    }
    if (Status == ABORT)
    {
        cout << "!";
        return 0;
    }

    W.Print();
}
