#include <iostream>

#define max 10000

using namespace std;

bool areCoprime(int a, int b) {
    if (a == b) return false;
    while (a != b) {
        if (a > b) a -= b;
        else b -= a;
    }

    return a == 1;
}

bool checkCoprimity(int _start, int _end, int nums[max]) {
    for (int a = _start; a < _end; a++) {
        for ( int b = a + 1; b < _end; b++) {
            if (!areCoprime(nums[a], nums[b])) return false;
        }
    }

    return true;
}

int main() {
    int nums[max];

    int n;

    cin >> n;

    for (int i = 0; i < n; i++) {
        int a;
        cin >> a;

        nums[i] = a;
    }

    int biggestChunk = 1;

    for (int _start = 0; _start < n; _start++) {
        int currChunk = 1;

        for (int _end = _start + 1; _end < n; _end++) {
            if (checkCoprimity(_start, _end, nums)) {
                int len = _end - _start;

                if (biggestChunk < len) {
                    biggestChunk = len;
                }
            }
        }
    }

    cout << biggestChunk;
}
