#include <iostream>
#include <cmath>
using namespace std;
const int maxn = 1e4+10, maxlog = 20, maxnum = 1024, buff_size = 2e5;
char buff[buff_size];
int buff_ix = buff_size-1;

void read_char() {
    if (++buff_ix == buff_size) fread(buff, 1, buff_size, stdin), buff_ix = 0;
}

void read_int(int &ret) {
    ret = 0;
    for (; buff[buff_ix] < '0' || buff[buff_ix] > '9'; read_char());
    for (; buff[buff_ix] >= '0' && buff[buff_ix] <= '9'; read_char())
        ret = 10 * ret + buff[buff_ix] - '0';
}

void read_string(char s[]) {
    int len = 0;
    for (; buff[buff_ix] == '\t' || buff[buff_ix] == ' ' || buff[buff_ix] == '\n' ; read_char());
    for (; buff[buff_ix] != '\t' && buff[buff_ix] != ' ' && buff[buff_ix] != '\n' ; read_char())
        s[len++] = buff[buff_ix];
    s[len] = '\0';
}

int a[maxn], ans[maxn], last[maxn], outp, n;


int f(int ix) {
    int ret = 0, sq = sqrt(a[ix]);
    for (int i = 2 ; i <= sq ; ++i) {
        if (a[ix] % i == 0) {
            ret = max(ret, max(last[a[ix]/i], last[i]));
        }
    }
    ret = max(ret, last[a[ix]]);
    return ret;
}

void mark(int ix) {
    int sq = sqrt(a[ix]);
    for (int i = 1 ; i <= sq ; ++i) {
        if (a[ix] % i == 0) {
            last[a[ix]/i] = ix;
            last[i] = ix;
        }
    }
}

int sparse[maxlog][maxn], power = 1;

int rmq(int l, int r) {
    int power = 1, log = 0;
    while (2*power < r-l+1) {
        power *= 2;
        ++log;
    }
    //cout << "query: " << l << ' ' << r << ' ' << power << ' ' << log << ' ' << max(sparse[log][l], sparse[log][r-power+1]) << '\n';
    return max(sparse[log][l], sparse[log][r-power+1]);
}

int main () {
    ios_base :: sync_with_stdio(0);
    cin.tie(nullptr);
    cout.tie(nullptr);
    read_int(n);
    for (int i = 1 ; i <= n ; ++i)
        read_int(a[i]);

    for (int i = 1 ; i <= n ; ++i) {
        sparse[0][i] = ans[i] = f(i);
        //cout << "f(" << i << "): " << ans[i] << '\n';
        mark(i);
    }

    for (int i = 1 ; power * 2 <= n ; ++i) {
        for (int j = 1 ; j <= n - 2*power + 1 ; ++j) {
            //cout << "i, j: " << i << ' ' << j << ' ' << power << ' ' << i+2*power-1 << '\n';
            sparse[i][j] = max(sparse[i-1][j], sparse[i-1][j+power]);
        }
        power *= 2;
    }

    for (int i = 1 ; i <= n ; ++i) {
        outp = max(outp, i - rmq(ans[i], i));
    }
    cout << outp << '\n';
    return 0;
}
