#include<iostream>
#include<algorithm>
#include<utility>

#define endl '\n'

using namespace std;

pair<long long, long long> solve_equation(long long a, long long b, long long c, long long p){
    long long gcd=__gcd(a, b);
    if(c%gcd!=0){
        return {0, 0};
    }

    long long step=b/gcd;

    pair<long long, long long> res;
    long long diff=1e18;
    for(long long i=p-2*step;i<=p+2*step;++i){
        if((c-i*a)%b==0 and abs(i-p)<=diff){
            res={i, (c-i*a)/b};
            diff=abs(i-p);
        }
    }

    return res;
}

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int tests;
    cin>>tests;

    while(tests--){
        long long a,b,c,p;
        cin>>a>>b>>c>>p;

        pair<long long, long long> res=solve_equation(a, b, c, p);
        cout<<res.first<<" "<<res.second<<endl;
    }
return 0;
}
