#include<iostream>
#include<algorithm>
#include<utility>

#define endl '\n'

using namespace std;

pair<long long, long long> extended_euclid(long long x, long long y){
    if(y==0){
        return {1, 0};
    }

    pair<long long, long long> res=extended_euclid(y, x%y);
    return {res.second, res.first-(x/y)*res.second};
}

pair<long long, long long> solve_equation(long long a, long long b, long long c, long long p){
    long long gcd=__gcd(a, b);
    if(c%gcd!=0){
        return {0, 0};
    }

    a/=gcd;
    b/=gcd;
    c/=gcd;

    pair<long long, long long> sol=extended_euclid(a, b);
    sol.first*=c;
    sol.second*=c;

    long long diff=abs(sol.first-p)/b;
    if(p>sol.first){
        long long new_sol1=sol.first+diff*b;
        long long new_sol2=sol.first+(diff+1)*b;

        if(abs(p-new_sol1)<abs(p-new_sol2)){
            sol={new_sol1, sol.second-diff*a};
        }else{
            sol={new_sol2, sol.second-(diff+1)*a};
        }
    }else{
        long long new_sol1=sol.first-diff*b;
        long long new_sol2=sol.first-(diff+1)*b;

        if(abs(p-new_sol1)<=abs(p-new_sol2)){
            sol={new_sol1, sol.second+diff*a};
        }else{
            sol={new_sol2, sol.second+(diff+1)*a};
        }
    }

    return sol;
}

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int tests;
    cin>>tests;

    while(tests--){
        long long a,b,c,p;
        cin>>a>>b>>c>>p;

        pair<long long, long long> res=solve_equation(a, b, c, p);
        cout<<res.first<<" "<<res.second<<endl;
    }
return 0;
}
