#include<iostream>
#include<algorithm>
#include<utility>

#define endl '\n'

using namespace std;

pair<int, int> extended_euclid(int x, int y){
    if(y==0){
        return {1, 0};
    }

    pair<int, int> res=extended_euclid(y, x%y);
    return {res.second, res.first-(x/y)*res.second};
}

pair<int, int> solve_equation(int a, int b, int c, int p){
    int gcd=__gcd(a, b);
    if(c%gcd!=0){
        return {0, 0};
    }

    a/=gcd;
    b/=gcd;
    c/=gcd;

    pair<int, int> sol=extended_euclid(a, b);
    sol.first*=c;
    sol.second*=c;

    /// TO DO: Find closest to p

    return sol;
}

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int tests;
    cin>>tests;

    while(tests--){
        int a,b,c,p;
        cin>>a>>b>>c>>p;

        pair<int, int> res=solve_equation(a, b, c, p);
        cout<<res.first<<" "<<res.second<<endl;
    }
return 0;
}
