#include <iostream>
#include <algorithm>
#include <cmath>
using namespace std;

int n;
int a, b, c, p;
int x, y;

pair<int, int> euclid(int a, int b)
{
    int x1 = 1, y1 = 0;
    int x2 = 0, y2 = -1;
    while(b > 0){
        int t1 = x2; int t2 = y2;
        x2 = x1 - (a/b)*x2;
        y2 = y1 - (a/b)*y2;
        x1 = t1; y1 = t2;
        a %= b;
        swap(a, b);
        //cout << a << " " << b << endl;
        //cout << x1 << " " << y1 << endl;
    }
    return {x1, y1};
}

int main(){

    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);

    pair<int, int> ans;
    //cout << ans.first << " " << ans.second << endl;

    cin >> n;
    for(int i = 0; i < n; i++){
        cin >> a >> b >> c >> p;
        int d = __gcd(a, b);
        if(c%d != 0){
            cout << 0 << " " << 0 << endl;
            continue;
        }
        a /= d; b /= d; c /= d;
        if(a >= b){
            ans = euclid(a, b);
            ans.second = -ans.second;
        }else{
            ans = euclid(b, a);
            ans.second = -ans.second;
            swap(ans.first, ans.second);
        }
        x = ans.first; y = ans.second;
        x *= c; y *= c;
        int k = (p-x)/b;
        x += k*b;
        y -= k*a;
        if(p >= 0){
            if(abs(p-x) >= abs(p-x-b)){
                x += b;
                y -= a;
            }
            if(abs(p-x) > abs(p-x+b)){
                x -= b;
                y += a;
            }
        }else{
            if(abs(p-x) >= abs(p-x-b)){
                x += b;
                y -= a;
            }
            if(abs(p-x) > abs(p-x+b)){
                x -= b;
                y += a;
            }
        }
        cout << x << " " << y << endl;
    }

return 0;
}
