#include <bits/stdc++.h>
using namespace std;
typedef long long ll;
#define endl "\n"

pair<ll, pair<ll, ll> > euclid(ll a, ll b) {
    if(a == 0) {
        return {b, {0, 1}};
    }
    auto sem = euclid(b % a , a);
    pair<ll, pair<ll, ll> > ret;
    ret.first = sem.first;
    ret.second.first = sem.second.second - (b / a) * sem.second.first;
    ret.second.second = sem.second.first;
    return ret;
}

signed main() {
    ios_base::sync_with_stdio(false); cin.tie(NULL);
    ll t;
    cin >> t;
    while(t --) {
        ll a, b, c, p;
        cin >> a >> b >> c >> p;
        auto ret = euclid(a, b);
        if(c % ret.first != 0) {
            cout << 0 << " " << 0 << endl;
            continue;
        }
        ll ac = a / ret.first, bc = b / ret.first;
        ret.second.first *= c / ret.first;
        ret.second.second *= c / ret.first;
        ll dw = ret.second.first + ((p - ret.second.first) / bc) * bc, up = ret.second.first + ((p - ret.second.first + bc - 1) / bc) * bc;
        if(abs(dw - p) < abs(up - p)) {
            cout << dw << " " << ret.second.second - ((p - ret.second.first) / bc) * ac << endl;
        } else {
            cout << up << " " << ret.second.second - ((p - ret.second.first + bc - 1) / bc) * ac << endl;
        }
    }
    return 0;
}

