#include <iostream>
#include <vector>

using namespace std;

typedef struct connection {
	int left;
	int right;
}connects;

bool is_it_neighboor(int left, int right, vector<connection> c) {
	for (vector<connection>::iterator it = c.begin(); it != c.end(); it++) {
		if ((*it).left == left && (*it).right == right)return true;
	}
	return false;
}

int sum_of_array(int array[], int size) {
	int sum = 0;
	for (int i = 0; i < size; i++) {
		sum += array[i];
	}
	return sum;
}

void copy_array(int left[], int right[], int size) {
	for (int i = 0; i < size; i++) {
		left[i] = right[i];
	}

}

int find_path(int edges[], vector<connects> connections, int size) {
	int cities[3] = {0};
	int already_visited;
	int solution[][3] = { 0 };
	int index = 0;
	for (int i = 0; i < size; i++) {
		already_visited = edges[i];
		for (int j = 0; j < size; j++) {
			if (j == i)continue;
			if (!is_it_neighboor(edges[i], edges[j], connections)) {
				cities[0] = edges[i];
				for (int k = 0; k < size; k++) {
					if (k == j)continue;
					if ((!is_it_neighboor(edges[j], edges[k], connections)) && (!is_it_neighboor(edges[k], edges[i], connections))
						&& edges[k] != already_visited) {
						cities[1] = edges[j];
						cities[2] = edges[k];
						copy_array(solution[index], cities, 3);
						index++;
					}
				}
			}
			
		}
	}
	int count_solutions = 0;
	int last = 0;
	for (int i = 0; i < index; i++) {
		int sum = sum_of_array(solution[i], 3);
		if (last == sum) {
			continue;
		}
		else {
			count_solutions++;
			last = sum;
		}
	}
	return count_solutions;
}


int main() {

	int N;
	cin >> N;

	int left, right;

	vector<connects> connections;
	int edges[100] = {0};


	for (int i = 1; i <= N; i++) {
		edges[i-1] = i;
	}

	for (int i = 0; i < N - 1; i++) {
		cin >> left >> right;
		connects curr = { left, right };
		connects curr_reverse = { right, left };
		connections.push_back(curr);
		connections.push_back(curr_reverse);
	}
	
	int result = find_path(edges, connections , N);

	cout << result << endl;

	return 0;
}