#include <iostream>
#include <vector>

using namespace std;

class Road{
public:
    int a;
    int b;
    Road(int a, int b): a(a), b(b) {}
};

class City{
public:
    vector<int> neighbours;
    int num;
    City(){}
    City(int a) : num(a){}
    void set_num(int a){
        num = a;
    }
    int is_neighbour(int a){
        for(unsigned int i = 0; i < neighbours.size();i++){
            if(a == neighbours[i])return 1;
        }
        if(a == num)return 1;
        return 0;
    }
};

class Couple{
public:
    int a;
    int b;
    int c;
    Couple(){}
    Couple(int a, int b, int c) : a(a), b(b), c(c){}
    void set_a(int a){
        this->a = a;
    }
    void set_b(int b){
        this->b = b;
    }
    void set_c(int c){
        this->c = c;
    }
    void sort1(){
        int k = 1;
        while(k){
            k = 0;
            if(a > b){
                int t = a;
                a = b;
                b = t;
                k = 1;
            }
            if(a > c){
                int t = a;
                a = c;
                c = t;
                k = 1;
            }
            if(b > c){
                int t = b;
                b = c;
                c = t;
                k = 1;
            }
        }
    }
};

class Country{
public:
    int count;
    vector<Road> routes;
    vector<City> cities;
    Country(int count) : count(count){
        for(int i = 0;i < count;i++){
            cities.push_back(City(i+1));
        }
    }
    void print(){
        for(int i = 0;i < count;i++){
            cout << cities[i].num << " ";
        }
        cout << endl;
    }
    void add_route(int a, int b){
        routes.push_back(Road(a,b));
    }
    void startup(){
        for(int i = 0;i < count-1;i++){
            cities[routes[i].a-1].neighbours.push_back(routes[i].b);
            cities[routes[i].b-1].neighbours.push_back(routes[i].a);
        }
    }
    int groups(){
        vector<Couple> fg;
        int k = 0;
        for(int i = 0;i < count;i++){
            for(int j = 0;j < count;j++){
                if(cities[i].is_neighbour(j+1) == 0){
                    for(int t = 0;t < count;t++){
                        if(cities[j].is_neighbour(t+1) == 0 && cities[t].is_neighbour(i+1) == 0){
                            k++;
                            fg.push_back(Couple(i,j,t));
                        }
                    }
                }
            }
        }
        for(unsigned int i = 0;i < fg.size();i++){
            fg[i].sort1();
        }
        vector<Couple> cp;
        cp.push_back(fg[0]);
        for(unsigned int i = 1;i < fg.size()-1;i++){
            int d = 0;
            for(unsigned int j = 0;j < cp.size();j++){
                if(fg[i].a == cp[j].a && fg[i].b == cp[j].b && fg[i].c == cp[j].c){
                    d = 1;
                    break;
                }
            }
            if(d == 0){
                cp.push_back(fg[i]);
            }
        }
        k = cp.size();
        return k;
    }
};

int main(){
    int n;
    do{
        cin >> n;
    }while(n < 1 || n > 100000);
    Country country = n;
    for(int i = 0;i < n-1;i++){
        int a,b;
        cin >> a >> b;
        country.add_route(a,b);
    }
    if(n <= 3){
        cout << 0;
        return 0;
    }
    //country.print1();
    country.startup();
    cout << country.groups();
    return 0;
}
