#include <iostream>
using namespace std;

const long long int m = 1000000007;
//const long long int m = 5;

typedef long long int matrix[5][5];
typedef long long int vec[5];

void matrix_assign(matrix a, matrix o) {
    for (long long int x=0; x<5; ++x) {
        for (long long int y=0; y<5; ++y) {
            o[x][y] = a[x][y];
        }
    }
}

void vec_assign(vec a, vec o) {
    for (long long int x=0; x<5; ++x) {
        o[x] = a[x];
    }
}

void matrix_add(matrix a, matrix b, matrix o) {
    for (long long int x=0; x<5; ++x) {
        for (long long int y=0; y<5; ++y) {
            o[x][y] = a[x][y] + b[x][y];
        }
    }
}

void matrix_mul(matrix a, matrix b, matrix o) {
    for (long long int x=0; x<5; ++x) {
        for (long long int y=0; y<5; ++y) {
            long long int res = 0;
            for (long long int i=0; i<5; ++i) {
                res += a[x][i] * b[i][y];
            }
            o[x][y] = res;
        }
    }
}

void matrix_mul_vec(matrix a, vec b, vec o) {
    for (long long int x=0; x<5; ++x) {
        long long int res = 0;
        for (long long int i=0; i<5; ++i) {
            res += a[x][i] * b[i];
        }
        o[x] = res;
    }
}

void matrix_mod(long long int m, matrix o) {
    for (long long int x=0; x<5; ++x) {
        for (long long int y=0; y<5; ++y) {
            o[x][y] = o[x][y] % m;
        }
    }
}

void vec_mod(long long int m, vec o) {
    for (long long int x=0; x<5; ++x) {
        o[x] = o[x] % m;
    }
}

matrix zero =
    {{0,0,0,0,0}
    ,{0,0,0,0,0}
    ,{0,0,0,0,0}
    ,{0,0,0,0,0}
    ,{0,0,0,0,0}};

matrix one =
    {{1,0,0,0,0}
    ,{0,1,0,0,0}
    ,{0,0,1,0,0}
    ,{0,0,0,1,0}
    ,{0,0,0,0,1}};

void binary_exponentiation(matrix a_in, long long int e, long long int m, matrix o) {
    matrix temp1;
    matrix temp2;

    matrix a;
    matrix_assign(a_in, a);
    matrix_assign(one, o);
    while (e) {
        //cout << "E LOOP: " << e << endl;
        if (e & 1) {
            matrix_mul(a, o, temp1);
            matrix_assign(temp1, o);
            matrix_mod(m, o);
        }
        matrix_mul(a, a, temp1);
        matrix_assign(temp1, a);
        matrix_mod(m, a);
        e /= 2;
    }
}

int main() {
    long long int n, t;
    cin >> n >> t;
    vec s;
    matrix p;

    if (t==1) {
        n--;
        vec ss = {1,2,3,0,0};
        matrix pp =
            {{0,1,0,0,0}
            ,{0,0,1,0,0}
            ,{0,1,1,0,0}
            ,{0,0,0,0,0}
            ,{0,0,0,0,0}};
        vec_assign(ss, s);
        matrix_assign(pp, p);
    } else if (t == 2) {
        n--;
        vec ss = {0,0,2,0,0};
        // something is wrong here
        matrix pp =
            {{0,1,0,0,0}
            ,{0,0,1,0,0}
            ,{0,0,0,1,1}
            ,{0,1,0,0,0}
            ,{0,1,0,0,0}};
        vec_assign(ss, s);
        matrix_assign(pp, p);
    } else if (t == 3) {
        n--;
        vec ss = {1,2,5,2,2};
        matrix pp =
            {{0,1,0,0,0}
            ,{0,0,1,0,0}
            ,{0,1,1,1,1}
            ,{0,1,0,0,1}
            ,{0,1,0,1,0}};
        vec_assign(ss, s);
        matrix_assign(pp, p);
    }
    matrix o;
    binary_exponentiation(p, n, m, o);

    /*
    for (long long int x=0; x<5; ++x) {
        for (long long int y=0; y<5; ++y) {
            cout << o[x][y] << " ";
        }
        cout << endl;
    }
    */

    vec oo;
    matrix_mul_vec(o, s, oo);
    long long int res = oo[0];
    res = res % m;
    cout << res;
}
